/*
 * Decompiled with CFR 0.152.
 */
package cd.connect.opentracing;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ObjectMapperProvider {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static TypeReference<Map<String, Object>> ref;

    public static String wrapObject(Object o) {
        try {
            return objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            return "{}";
        }
    }

    public static Map<String, Object> unwrapMap(String s) {
        if (s == null) {
            return new HashMap<String, Object>();
        }
        try {
            return (Map)objectMapper.readValue(s, ref);
        }
        catch (IOException e) {
            return new HashMap<String, Object>();
        }
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ref = new TypeReference<Map<String, Object>>(){};
    }
}

