/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.api.response;

import com.thoughtworks.go.plugin.api.response.GoApiResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultGoApiResponse
extends GoApiResponse {
    public static final int SUCCESS_RESPONSE_CODE = 200;
    public static final int REDIRECT_RESPONSE_CODE = 302;
    public static final int INTERNAL_ERROR = 500;
    public static final int VALIDATION_ERROR = 412;
    private int responseCode;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private String responseBody;

    public DefaultGoApiResponse(int responseCode) {
        this.responseCode = responseCode;
    }

    public static DefaultGoApiResponse incompleteRequest(String responseBody) {
        DefaultGoApiResponse defaultGoApiResponse = new DefaultGoApiResponse(412);
        defaultGoApiResponse.setResponseBody(responseBody);
        return defaultGoApiResponse;
    }

    public static DefaultGoApiResponse badRequest(String responseBody) {
        DefaultGoApiResponse defaultGoApiResponse = new DefaultGoApiResponse(400);
        defaultGoApiResponse.setResponseBody(responseBody);
        return defaultGoApiResponse;
    }

    public static DefaultGoApiResponse error(String responseBody) {
        DefaultGoApiResponse defaultGoApiResponse = new DefaultGoApiResponse(500);
        defaultGoApiResponse.setResponseBody(responseBody);
        return defaultGoApiResponse;
    }

    public static DefaultGoApiResponse success(String responseBody) {
        DefaultGoApiResponse defaultGoApiResponse = new DefaultGoApiResponse(200);
        defaultGoApiResponse.setResponseBody(responseBody);
        return defaultGoApiResponse;
    }

    public void addResponseHeader(String name, String value) {
        this.responseHeaders.put(name, value);
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    @Override
    public int responseCode() {
        return this.responseCode;
    }

    @Override
    public Map<String, String> responseHeaders() {
        return Collections.unmodifiableMap(this.responseHeaders);
    }

    @Override
    public String responseBody() {
        return this.responseBody;
    }
}

