/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.api.response;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Result {
    private Status status = Status.SUCCESS;
    private List<String> messages = new ArrayList<String>();

    public boolean isSuccessful() {
        return Status.SUCCESS == this.status;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public Result withErrorMessages(String ... errors) {
        return this.withErrorMessages(Arrays.asList(errors));
    }

    public Result withErrorMessages(List<String> errorList) {
        return this.withStatusAndMessages(Status.FAILURE, errorList);
    }

    public Result withSuccessMessages(String ... successMessages) {
        List<String> msgList = Arrays.asList(successMessages);
        return this.withSuccessMessages(msgList);
    }

    public Result withSuccessMessages(List<String> successMessages) {
        return this.withStatusAndMessages(Status.SUCCESS, successMessages);
    }

    private Result withStatusAndMessages(Status status, List<String> messages) {
        this.status = status;
        this.messages.addAll(messages);
        return this;
    }

    public String getMessagesForDisplay() {
        if (this.messages.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String message : this.messages) {
            stringBuilder.append(message);
            stringBuilder.append("\n");
        }
        String tempStr = stringBuilder.toString();
        stringBuilder.deleteCharAt(tempStr.length() - 1);
        return stringBuilder.toString();
    }

    private static enum Status {
        SUCCESS,
        FAILURE;

    }
}

