/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.api.request;

import com.thoughtworks.go.plugin.api.request.GoPluginApiRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultGoPluginApiRequest
extends GoPluginApiRequest {
    private String extension;
    private String extensionVersion;
    private String requestName;
    private Map<String, String> requestParameters = new HashMap<String, String>();
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String requestBody;

    public DefaultGoPluginApiRequest(String extension, String extensionVersion, String requestName) {
        this.extension = extension;
        this.extensionVersion = extensionVersion;
        this.requestName = requestName;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void addRequestParameter(String name, String value) {
        this.requestParameters.put(name, value);
    }

    public void addRequestHeader(String name, String value) {
        this.requestHeaders.put(name, value);
    }

    @Override
    public String extension() {
        return this.extension;
    }

    @Override
    public String extensionVersion() {
        return this.extensionVersion;
    }

    @Override
    public String requestName() {
        return this.requestName;
    }

    @Override
    public Map<String, String> requestParameters() {
        return Collections.unmodifiableMap(this.requestParameters);
    }

    @Override
    public Map<String, String> requestHeaders() {
        return Collections.unmodifiableMap(this.requestHeaders);
    }

    @Override
    public String requestBody() {
        return this.requestBody;
    }

    public void setRequestParams(Map<String, String> params) {
        if (params != null) {
            this.requestParameters = params;
        }
    }
}

