/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.api.logging;

import com.thoughtworks.go.plugin.internal.api.LoggingService;
import java.lang.reflect.Field;

public class Logger {
    private String pluginId;
    private static LoggingService loggingService;
    private final String loggerName;

    public static Logger getLoggerFor(Class loggerClass) {
        String id = null;
        try {
            Class<?> defaultGoPluginActivator = loggerClass.getClassLoader().loadClass("com.thoughtworks.go.plugin.activation.DefaultGoPluginActivator");
            id = (String)Logger.getStaticField(defaultGoPluginActivator, "pluginId");
        }
        catch (Exception e) {
            id = "UNKNOWN";
            System.err.println("Could not find pluginId for logger: " + loggerClass.toString());
        }
        return new Logger(loggerClass.getName(), id);
    }

    public static void initialize(LoggingService loggingService) {
        Logger.loggingService = loggingService;
    }

    private Logger(String loggerName, String pluginId) {
        this.loggerName = loggerName;
        this.pluginId = pluginId;
    }

    public void debug(String message) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.debug(this.pluginId, this.loggerName, message);
    }

    public void debug(String message, Throwable throwable) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.debug(this.pluginId, this.loggerName, message, throwable);
    }

    public void debug(String message, Object arg) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.debug(this.pluginId, this.loggerName, message, arg);
    }

    public void debug(String message, Object arg1, Object arg2) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.debug(this.pluginId, this.loggerName, message, arg1, arg2);
    }

    public void debug(String message, Object ... arguments) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.debug(this.pluginId, this.loggerName, message, arguments);
    }

    public void info(String message) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.info(this.pluginId, this.loggerName, message);
    }

    public void info(String message, Throwable throwable) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.info(this.pluginId, this.loggerName, message, throwable);
    }

    public void info(String message, Object arg) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.info(this.pluginId, this.loggerName, message, arg);
    }

    public void info(String message, Object arg1, Object arg2) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.info(this.pluginId, this.loggerName, message, arg1, arg2);
    }

    public void info(String message, Object ... arguments) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.info(this.pluginId, this.loggerName, message, arguments);
    }

    public void warn(String message) {
        if (loggingService == null) {
            System.err.println(message);
            return;
        }
        loggingService.warn(this.pluginId, this.loggerName, message);
    }

    public void warn(String message, Throwable throwable) {
        if (loggingService == null) {
            System.err.println(message);
            return;
        }
        loggingService.warn(this.pluginId, this.loggerName, message, throwable);
    }

    public void warn(String message, Object arg) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.warn(this.pluginId, this.loggerName, message, arg);
    }

    public void warn(String message, Object arg1, Object arg2) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.warn(this.pluginId, this.loggerName, message, arg1, arg2);
    }

    public void warn(String message, Object ... arguments) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.warn(this.pluginId, this.loggerName, message, arguments);
    }

    public void error(String message) {
        if (loggingService == null) {
            System.err.println(message);
            return;
        }
        loggingService.error(this.pluginId, this.loggerName, message);
    }

    public void error(String message, Throwable throwable) {
        if (loggingService == null) {
            System.err.println(message);
            return;
        }
        loggingService.error(this.pluginId, this.loggerName, message, throwable);
    }

    public void error(String message, Object arg) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.error(this.pluginId, this.loggerName, message, arg);
    }

    public void error(String message, Object arg1, Object arg2) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.error(this.pluginId, this.loggerName, message, arg1, arg2);
    }

    public void error(String message, Object ... arguments) {
        if (loggingService == null) {
            System.out.println(message);
            return;
        }
        loggingService.error(this.pluginId, this.loggerName, message, arguments);
    }

    private static Object getStaticField(Class kls, String name) {
        try {
            Field field = kls.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

