/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.codec;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.go.plugin.configrepo.codec.TypeAdapter;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRAbstractFetchTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRBuildFramework;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRBuildTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRExecTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRNantTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRPluggableTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;
import java.lang.reflect.Type;

public class TaskTypeAdapter
extends TypeAdapter
implements JsonDeserializer<CRTask>,
JsonSerializer<CRTask> {
    private static final String TYPE = "type";

    public CRTask deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        return (CRTask)this.determineJsonElementForDistinguishingImplementers(json, context, TYPE, "artifact_origin");
    }

    @Override
    protected Class<?> classForName(String typeName, String origin) {
        if (typeName.equals("exec")) {
            return CRExecTask.class;
        }
        if (typeName.equals(CRBuildFramework.rake.toString())) {
            return CRBuildTask.class;
        }
        if (typeName.equals(CRBuildFramework.ant.toString())) {
            return CRBuildTask.class;
        }
        if (typeName.equals(CRBuildFramework.nant.toString())) {
            return CRNantTask.class;
        }
        if (typeName.equals("plugin")) {
            return CRPluggableTask.class;
        }
        if (typeName.equals("fetch")) {
            return CRAbstractFetchTask.ArtifactOrigin.getArtifactOrigin(origin).getArtifactTaskClass();
        }
        throw new JsonParseException(String.format("Invalid or unknown task type '%s'.", typeName));
    }

    public JsonElement serialize(CRTask crTask, Type type, JsonSerializationContext context) {
        JsonObject retValue = context.serialize((Object)crTask).getAsJsonObject();
        CRTask onCancel = crTask.getOnCancel();
        if (onCancel != null) {
            retValue.remove("onCancel");
            retValue.add("onCancel", context.serialize((Object)onCancel));
        }
        return retValue;
    }
}

