/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.CREnvironmentVariable;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class CREnvironment
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="environment_variables")
    @Expose
    private Collection<CREnvironmentVariable> environmentVariables = new ArrayList<CREnvironmentVariable>();
    @SerializedName(value="agents")
    @Expose
    private Collection<String> agents = new ArrayList<String>();
    @SerializedName(value="pipelines")
    @Expose
    private Collection<String> pipelines = new ArrayList<String>();

    public CREnvironment() {
        this(null);
    }

    public CREnvironment(String name) {
        this.name = name;
    }

    public void addEnvironmentVariable(String key, String value) {
        CREnvironmentVariable variable = new CREnvironmentVariable(key);
        variable.setValue(value);
        this.environmentVariables.add(variable);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        this.validateEnvironmentVariableUniqueness(errors, location);
        this.validateAgentUniqueness(errors, location);
        this.validatePipelineUniqueness(errors, location);
    }

    private void validateEnvironmentVariableUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CREnvironmentVariable var : this.environmentVariables) {
            String error = var.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateAgentUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (String agent : this.agents) {
            String lowerCase = agent.toLowerCase();
            if (keys.contains(lowerCase)) {
                errors.addError(location, String.format("Agent %s is defined more than once", agent));
                continue;
            }
            keys.add(lowerCase);
        }
    }

    private void validatePipelineUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (String pipeline : this.pipelines) {
            String lowerCase = pipeline.toLowerCase();
            if (keys.contains(lowerCase)) {
                errors.addError(location, String.format("Pipeline %s is defined more than once", pipeline));
                continue;
            }
            keys.add(lowerCase);
        }
    }

    public void addAgent(String agentUuid) {
        this.agents.add(agentUuid);
    }

    public void addPipeline(String pipeline1) {
        this.pipelines.add(pipeline1);
    }

    public String validateNameUniqueness(HashSet<String> keys) {
        if (keys.contains(this.getName())) {
            return String.format("Environment %s is defined more than once", this.getName());
        }
        keys.add(this.getName());
        return null;
    }

    @Override
    public String getLocation(String parent) {
        return StringUtils.isBlank((CharSequence)this.location) ? (StringUtils.isBlank((CharSequence)this.name) ? String.format("Environment in %s", parent) : String.format("Environment %s", this.name)) : String.format("%s; Environment %s", this.location, this.name);
    }

    public String getName() {
        return this.name;
    }

    public Collection<CREnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Collection<String> getAgents() {
        return this.agents;
    }

    public Collection<String> getPipelines() {
        return this.pipelines;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnvironmentVariables(Collection<CREnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setAgents(Collection<String> agents) {
        this.agents = agents;
    }

    public void setPipelines(Collection<String> pipelines) {
        this.pipelines = pipelines;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CREnvironment)) {
            return false;
        }
        CREnvironment other = (CREnvironment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Collection<CREnvironmentVariable> this$environmentVariables = this.getEnvironmentVariables();
        Collection<CREnvironmentVariable> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Collection<String> this$agents = this.getAgents();
        Collection<String> other$agents = other.getAgents();
        if (this$agents == null ? other$agents != null : !((Object)this$agents).equals(other$agents)) {
            return false;
        }
        Collection<String> this$pipelines = this.getPipelines();
        Collection<String> other$pipelines = other.getPipelines();
        return !(this$pipelines == null ? other$pipelines != null : !((Object)this$pipelines).equals(other$pipelines));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CREnvironment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Collection<CREnvironmentVariable> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Collection<String> $agents = this.getAgents();
        result = result * 59 + ($agents == null ? 43 : ((Object)$agents).hashCode());
        Collection<String> $pipelines = this.getPipelines();
        result = result * 59 + ($pipelines == null ? 43 : ((Object)$pipelines).hashCode());
        return result;
    }
}

