/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CREnvironmentVariable
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="value")
    @Expose
    private String value;
    @SerializedName(value="encrypted_value")
    @Expose
    private String encryptedValue;

    public CREnvironmentVariable() {
    }

    public CREnvironmentVariable(String name) {
        this.name = name;
    }

    public CREnvironmentVariable(String key, String value) {
        this.name = key;
        this.value = value;
    }

    public CREnvironmentVariable(String name, String value, String encryptedValue) {
        this.name = name;
        this.value = value;
        this.encryptedValue = encryptedValue;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String validateNameUniqueness(HashSet<String> keys) {
        if (keys.contains(this.getName())) {
            return String.format("Environment variable %s defined more than once", this.getName());
        }
        keys.add(this.getName());
        return null;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "name", this.name);
        this.validateValue(errors, location);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String key = this.name == null ? "unknown name" : this.name;
        return String.format("%s; Environment variable (%s)", myLocation, key);
    }

    private void validateValue(ErrorCollection errors, String location) {
        if (StringUtils.isBlank((CharSequence)this.value) && StringUtils.isBlank((CharSequence)this.encryptedValue)) {
            errors.addError(location, "Environment variable value not set");
        }
        if (!StringUtils.isBlank((CharSequence)this.value) && !StringUtils.isBlank((CharSequence)this.encryptedValue)) {
            errors.addError(location, "Environment variable value and encrypted_value is set. Only one field can be assigned.");
        }
    }

    public boolean hasEncryptedValue() {
        return !StringUtils.isBlank((CharSequence)this.encryptedValue);
    }

    public boolean hasValue() {
        return !StringUtils.isBlank((CharSequence)this.value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncryptedValue() {
        return this.encryptedValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setEncryptedValue(String encryptedValue) {
        this.encryptedValue = encryptedValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CREnvironmentVariable)) {
            return false;
        }
        CREnvironmentVariable other = (CREnvironmentVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$encryptedValue = this.getEncryptedValue();
        String other$encryptedValue = other.getEncryptedValue();
        return !(this$encryptedValue == null ? other$encryptedValue != null : !this$encryptedValue.equals(other$encryptedValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CREnvironmentVariable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $encryptedValue = this.getEncryptedValue();
        result = result * 59 + ($encryptedValue == null ? 43 : $encryptedValue.hashCode());
        return result;
    }
}

