/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;

public class CRMingle
extends CRBase {
    @SerializedName(value="base_url")
    @Expose
    private String baseUrl;
    @SerializedName(value="project_identifier")
    @Expose
    private String projectIdentifier;
    @SerializedName(value="mql_grouping_conditions")
    @Expose
    private String mqlGroupingConditions;

    public CRMingle() {
    }

    public CRMingle(String baseUrl, String projectId) {
        this.baseUrl = baseUrl;
        this.projectIdentifier = projectId;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "project_identifier", this.projectIdentifier);
        errors.checkMissing(location, "base_url", this.baseUrl);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; Mingle", myLocation);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public String getMqlGroupingConditions() {
        return this.mqlGroupingConditions;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setProjectIdentifier(String projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    public void setMqlGroupingConditions(String mqlGroupingConditions) {
        this.mqlGroupingConditions = mqlGroupingConditions;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRMingle)) {
            return false;
        }
        CRMingle other = (CRMingle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$projectIdentifier = this.getProjectIdentifier();
        String other$projectIdentifier = other.getProjectIdentifier();
        if (this$projectIdentifier == null ? other$projectIdentifier != null : !this$projectIdentifier.equals(other$projectIdentifier)) {
            return false;
        }
        String this$mqlGroupingConditions = this.getMqlGroupingConditions();
        String other$mqlGroupingConditions = other.getMqlGroupingConditions();
        return !(this$mqlGroupingConditions == null ? other$mqlGroupingConditions != null : !this$mqlGroupingConditions.equals(other$mqlGroupingConditions));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRMingle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $projectIdentifier = this.getProjectIdentifier();
        result = result * 59 + ($projectIdentifier == null ? 43 : $projectIdentifier.hashCode());
        String $mqlGroupingConditions = this.getMqlGroupingConditions();
        result = result * 59 + ($mqlGroupingConditions == null ? 43 : $mqlGroupingConditions.hashCode());
        return result;
    }
}

