/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.config.PipelineConfig;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.CREnvironmentVariable;
import com.thoughtworks.go.plugin.configrepo.contract.CRMingle;
import com.thoughtworks.go.plugin.configrepo.contract.CRParameter;
import com.thoughtworks.go.plugin.configrepo.contract.CRStage;
import com.thoughtworks.go.plugin.configrepo.contract.CRTimer;
import com.thoughtworks.go.plugin.configrepo.contract.CRTrackingTool;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.SourceCodeMaterial;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CRPipeline
extends CRBase {
    @SerializedName(value="group")
    @Expose
    private String group;
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="display_order_weight")
    @Expose
    private int displayOrderWeight = -1;
    @SerializedName(value="label_template")
    @Expose
    private String labelTemplate;
    @SerializedName(value="lock_behavior")
    @Expose
    private String lockBehavior;
    @SerializedName(value="tracking_tool")
    @Expose
    private CRTrackingTool trackingTool;
    @SerializedName(value="mingle")
    @Expose
    private CRMingle mingle;
    @SerializedName(value="timer")
    @Expose
    private CRTimer timer;
    @SerializedName(value="environment_variables")
    @Expose
    private Collection<CREnvironmentVariable> environmentVariables = new ArrayList<CREnvironmentVariable>();
    @SerializedName(value="parameters")
    @Expose
    private Collection<CRParameter> parameters = new ArrayList<CRParameter>();
    @SerializedName(value="materials")
    @Expose
    private Collection<CRMaterial> materials = new ArrayList<CRMaterial>();
    @SerializedName(value="stages")
    @Expose
    private List<CRStage> stages = new ArrayList<CRStage>();
    @SerializedName(value="template")
    @Expose
    private String template;

    public CRPipeline() {
    }

    public CRPipeline(String name, String groupName) {
        this.name = name;
        this.group = groupName;
    }

    public boolean hasEnvironmentVariable(String key) {
        for (CREnvironmentVariable var : this.environmentVariables) {
            if (!var.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public CRMaterial getMaterialByName(String name) {
        if (this.materials == null) {
            return null;
        }
        for (CRMaterial m : this.materials) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public void addMaterial(CRMaterial material) {
        this.materials.add(material);
    }

    public void addStage(CRStage stage) {
        this.stages.add(stage);
    }

    public void addParameter(CRParameter param) {
        this.parameters.add(param);
    }

    public void addEnvironmentVariable(String key, String value) {
        CREnvironmentVariable variable = new CREnvironmentVariable(key);
        variable.setValue(value);
        this.environmentVariables.add(variable);
    }

    public void addEnvironmentVariable(CREnvironmentVariable variable) {
        this.environmentVariables.add(variable);
    }

    @Override
    public String getLocation(String parent) {
        return StringUtils.isBlank((CharSequence)this.location) ? (StringUtils.isBlank((CharSequence)this.name) ? String.format("Pipeline in %s", parent) : String.format("Pipeline %s", this.name)) : String.format("%s; Pipeline %s", this.location, this.name);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "name", this.name);
        errors.checkMissing(location, "group", this.group);
        errors.checkMissing(location, "materials", this.materials);
        this.validateAtLeastOneMaterial(errors, location);
        if (this.materials != null) {
            for (CRMaterial material : this.materials) {
                material.getErrors(errors, location);
            }
            if (this.materials.size() > 1) {
                this.validateMaterialNameUniqueness(errors, location);
                this.validateScmMaterials(errors, location);
            }
        }
        this.validateTemplateOrStages(errors, location);
        if (!this.hasTemplate()) {
            this.validateAtLeastOneStage(errors, location);
            if (this.stages != null) {
                for (CRStage stage : this.stages) {
                    stage.getErrors(errors, location);
                }
                if (this.stages.size() > 1) {
                    this.validateStageNameUniqueness(errors, location);
                }
            }
        }
        this.validateEnvironmentVariableUniqueness(errors, location);
        this.validateParamNameUniqueness(errors, location);
        this.validateLockBehaviorValue(errors, location);
    }

    private void validateLockBehaviorValue(ErrorCollection errors, String location) {
        if (this.lockBehavior != null && !PipelineConfig.VALID_LOCK_VALUES.contains(this.lockBehavior)) {
            errors.addError(location, MessageFormat.format("Lock behavior has an invalid value ({0}). Valid values are: {1}", this.lockBehavior, PipelineConfig.VALID_LOCK_VALUES));
        }
    }

    private void validateEnvironmentVariableUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CREnvironmentVariable var : this.environmentVariables) {
            String error = var.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateParamNameUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CRParameter param : this.parameters) {
            String error = param.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateScmMaterials(ErrorCollection errors, String pipelineLocation) {
        List<SourceCodeMaterial> allSCMMaterials = this.filterScmMaterials();
        if (allSCMMaterials.size() > 1) {
            for (SourceCodeMaterial material : allSCMMaterials) {
                String directory = material.getDestination();
                if (!StringUtils.isBlank((CharSequence)directory)) continue;
                String location = material.getLocation(pipelineLocation);
                errors.addError(location, "Material must have destination directory when there are many SCM materials");
            }
        }
    }

    private List<SourceCodeMaterial> filterScmMaterials() {
        ArrayList<SourceCodeMaterial> scmMaterials = new ArrayList<SourceCodeMaterial>();
        for (CRMaterial material : this.materials) {
            if (!(material instanceof SourceCodeMaterial)) continue;
            scmMaterials.add((SourceCodeMaterial)((Object)material));
        }
        return scmMaterials;
    }

    private void validateStageNameUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CRStage stage : this.stages) {
            String error = stage.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateMaterialNameUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CRMaterial material1 : this.materials) {
            String error = material1.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateAtLeastOneStage(ErrorCollection errors, String location) {
        if (!this.hasStages()) {
            errors.addError(location, "Pipeline has no stages.");
        }
    }

    private boolean hasStages() {
        return this.stages != null && !this.stages.isEmpty();
    }

    private void validateTemplateOrStages(ErrorCollection errors, String location) {
        if (!this.hasTemplate() && !this.hasStages()) {
            errors.addError(location, "Pipeline has to define stages or template.");
        } else if (this.hasTemplate() && this.hasStages()) {
            errors.addError(location, "Pipeline has to either define stages or template. Not both.");
        }
    }

    private void validateAtLeastOneMaterial(ErrorCollection errors, String location) {
        if (this.materials == null || this.materials.isEmpty()) {
            errors.addError(location, "Pipeline has no materials.");
        }
    }

    public boolean hasTemplate() {
        return this.template != null && !StringUtils.isBlank((CharSequence)this.template);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public int getDisplayOrderWeight() {
        return this.displayOrderWeight;
    }

    public String getLabelTemplate() {
        return this.labelTemplate;
    }

    public String getLockBehavior() {
        return this.lockBehavior;
    }

    public CRTrackingTool getTrackingTool() {
        return this.trackingTool;
    }

    public CRMingle getMingle() {
        return this.mingle;
    }

    public CRTimer getTimer() {
        return this.timer;
    }

    public Collection<CREnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Collection<CRParameter> getParameters() {
        return this.parameters;
    }

    public Collection<CRMaterial> getMaterials() {
        return this.materials;
    }

    public List<CRStage> getStages() {
        return this.stages;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayOrderWeight(int displayOrderWeight) {
        this.displayOrderWeight = displayOrderWeight;
    }

    public void setLabelTemplate(String labelTemplate) {
        this.labelTemplate = labelTemplate;
    }

    public void setLockBehavior(String lockBehavior) {
        this.lockBehavior = lockBehavior;
    }

    public void setTrackingTool(CRTrackingTool trackingTool) {
        this.trackingTool = trackingTool;
    }

    public void setMingle(CRMingle mingle) {
        this.mingle = mingle;
    }

    public void setTimer(CRTimer timer) {
        this.timer = timer;
    }

    public void setEnvironmentVariables(Collection<CREnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setParameters(Collection<CRParameter> parameters) {
        this.parameters = parameters;
    }

    public void setMaterials(Collection<CRMaterial> materials) {
        this.materials = materials;
    }

    public void setStages(List<CRStage> stages) {
        this.stages = stages;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRPipeline)) {
            return false;
        }
        CRPipeline other = (CRPipeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getDisplayOrderWeight() != other.getDisplayOrderWeight()) {
            return false;
        }
        String this$labelTemplate = this.getLabelTemplate();
        String other$labelTemplate = other.getLabelTemplate();
        if (this$labelTemplate == null ? other$labelTemplate != null : !this$labelTemplate.equals(other$labelTemplate)) {
            return false;
        }
        String this$lockBehavior = this.getLockBehavior();
        String other$lockBehavior = other.getLockBehavior();
        if (this$lockBehavior == null ? other$lockBehavior != null : !this$lockBehavior.equals(other$lockBehavior)) {
            return false;
        }
        CRTrackingTool this$trackingTool = this.getTrackingTool();
        CRTrackingTool other$trackingTool = other.getTrackingTool();
        if (this$trackingTool == null ? other$trackingTool != null : !((Object)this$trackingTool).equals(other$trackingTool)) {
            return false;
        }
        CRMingle this$mingle = this.getMingle();
        CRMingle other$mingle = other.getMingle();
        if (this$mingle == null ? other$mingle != null : !((Object)this$mingle).equals(other$mingle)) {
            return false;
        }
        CRTimer this$timer = this.getTimer();
        CRTimer other$timer = other.getTimer();
        if (this$timer == null ? other$timer != null : !((Object)this$timer).equals(other$timer)) {
            return false;
        }
        Collection<CREnvironmentVariable> this$environmentVariables = this.getEnvironmentVariables();
        Collection<CREnvironmentVariable> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Collection<CRParameter> this$parameters = this.getParameters();
        Collection<CRParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Collection<CRMaterial> this$materials = this.getMaterials();
        Collection<CRMaterial> other$materials = other.getMaterials();
        if (this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials)) {
            return false;
        }
        List<CRStage> this$stages = this.getStages();
        List<CRStage> other$stages = other.getStages();
        if (this$stages == null ? other$stages != null : !((Object)this$stages).equals(other$stages)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        return !(this$template == null ? other$template != null : !this$template.equals(other$template));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRPipeline;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getDisplayOrderWeight();
        String $labelTemplate = this.getLabelTemplate();
        result = result * 59 + ($labelTemplate == null ? 43 : $labelTemplate.hashCode());
        String $lockBehavior = this.getLockBehavior();
        result = result * 59 + ($lockBehavior == null ? 43 : $lockBehavior.hashCode());
        CRTrackingTool $trackingTool = this.getTrackingTool();
        result = result * 59 + ($trackingTool == null ? 43 : ((Object)$trackingTool).hashCode());
        CRMingle $mingle = this.getMingle();
        result = result * 59 + ($mingle == null ? 43 : ((Object)$mingle).hashCode());
        CRTimer $timer = this.getTimer();
        result = result * 59 + ($timer == null ? 43 : ((Object)$timer).hashCode());
        Collection<CREnvironmentVariable> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Collection<CRParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Collection<CRMaterial> $materials = this.getMaterials();
        result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
        List<CRStage> $stages = this.getStages();
        result = result * 59 + ($stages == null ? 43 : ((Object)$stages).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        return result;
    }
}

