/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;

public class CRPropertyGenerator
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="source")
    @Expose
    private String source;
    @SerializedName(value="xpath")
    @Expose
    private String xpath;

    public CRPropertyGenerator(String name, String src, String xpath) {
        this.name = name;
        this.source = src;
        this.xpath = xpath;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "name", this.name);
        errors.checkMissing(location, "source", this.source);
        errors.checkMissing(location, "xpath", this.xpath);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "unknown name" : this.name;
        return String.format("%s; Property generator (%s)", myLocation, name);
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRPropertyGenerator)) {
            return false;
        }
        CRPropertyGenerator other = (CRPropertyGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$xpath = this.getXpath();
        String other$xpath = other.getXpath();
        return !(this$xpath == null ? other$xpath != null : !this$xpath.equals(other$xpath));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRPropertyGenerator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $xpath = this.getXpath();
        result = result * 59 + ($xpath == null ? 43 : $xpath.hashCode());
        return result;
    }
}

