/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRApproval;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.CREnvironmentVariable;
import com.thoughtworks.go.plugin.configrepo.contract.CRJob;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class CRStage
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="fetch_materials")
    @Expose
    private boolean fetchMaterials = true;
    @SerializedName(value="never_cleanup_artifacts")
    @Expose
    private boolean neverCleanupArtifacts;
    @SerializedName(value="clean_working_directory")
    @Expose
    private boolean cleanWorkingDirectory;
    @SerializedName(value="approval")
    @Expose
    private CRApproval approval;
    @SerializedName(value="environment_variables")
    @Expose
    private Collection<CREnvironmentVariable> environmentVariables = new ArrayList<CREnvironmentVariable>();
    @SerializedName(value="jobs")
    @Expose
    private Collection<CRJob> jobs = new ArrayList<CRJob>();

    public CRStage() {
    }

    public CRStage(String name) {
        this.name = name;
    }

    public void addEnvironmentVariable(String key, String value) {
        CREnvironmentVariable variable = new CREnvironmentVariable(key);
        variable.setValue(value);
        this.environmentVariables.add(variable);
    }

    public void addEnvironmentVariable(CREnvironmentVariable variable) {
        this.environmentVariables.add(variable);
    }

    private void validateJobNameUniqueness(ErrorCollection errors, String location) {
        if (this.jobs == null) {
            return;
        }
        HashSet<String> keys = new HashSet<String>();
        for (CRJob var : this.jobs) {
            String error = var.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateEnvironmentVariableUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CREnvironmentVariable var : this.environmentVariables) {
            String error = var.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    private void validateAtLeastOneJob(ErrorCollection errors, String location) {
        if (this.jobs == null || this.jobs.isEmpty()) {
            errors.addError(location, "Stage has no jobs");
        }
    }

    public boolean hasEnvironmentVariable(String key) {
        for (CREnvironmentVariable var : this.environmentVariables) {
            if (!var.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "name", this.name);
        this.validateAtLeastOneJob(errors, location);
        this.validateEnvironmentVariableUniqueness(errors, location);
        this.validateJobNameUniqueness(errors, location);
        if (this.approval != null) {
            this.approval.getErrors(errors, location);
        }
        if (this.jobs != null) {
            for (CRJob job : this.jobs) {
                job.getErrors(errors, location);
            }
        }
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String stage = this.getName() == null ? "unknown name" : this.getName();
        return String.format("%s; Stage (%s)", myLocation, stage);
    }

    public String validateNameUniqueness(HashSet<String> keys) {
        if (keys.contains(this.getName())) {
            return String.format("Stage named %s is defined more than once", this.getName());
        }
        keys.add(this.getName());
        return null;
    }

    public void addJob(CRJob crJob) {
        this.jobs.add(crJob);
    }

    public String getName() {
        return this.name;
    }

    public boolean isFetchMaterials() {
        return this.fetchMaterials;
    }

    public boolean isNeverCleanupArtifacts() {
        return this.neverCleanupArtifacts;
    }

    public boolean isCleanWorkingDirectory() {
        return this.cleanWorkingDirectory;
    }

    public CRApproval getApproval() {
        return this.approval;
    }

    public Collection<CREnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Collection<CRJob> getJobs() {
        return this.jobs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFetchMaterials(boolean fetchMaterials) {
        this.fetchMaterials = fetchMaterials;
    }

    public void setNeverCleanupArtifacts(boolean neverCleanupArtifacts) {
        this.neverCleanupArtifacts = neverCleanupArtifacts;
    }

    public void setCleanWorkingDirectory(boolean cleanWorkingDirectory) {
        this.cleanWorkingDirectory = cleanWorkingDirectory;
    }

    public void setApproval(CRApproval approval) {
        this.approval = approval;
    }

    public void setEnvironmentVariables(Collection<CREnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setJobs(Collection<CRJob> jobs) {
        this.jobs = jobs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRStage)) {
            return false;
        }
        CRStage other = (CRStage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isFetchMaterials() != other.isFetchMaterials()) {
            return false;
        }
        if (this.isNeverCleanupArtifacts() != other.isNeverCleanupArtifacts()) {
            return false;
        }
        if (this.isCleanWorkingDirectory() != other.isCleanWorkingDirectory()) {
            return false;
        }
        CRApproval this$approval = this.getApproval();
        CRApproval other$approval = other.getApproval();
        if (this$approval == null ? other$approval != null : !((Object)this$approval).equals(other$approval)) {
            return false;
        }
        Collection<CREnvironmentVariable> this$environmentVariables = this.getEnvironmentVariables();
        Collection<CREnvironmentVariable> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Collection<CRJob> this$jobs = this.getJobs();
        Collection<CRJob> other$jobs = other.getJobs();
        return !(this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRStage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isFetchMaterials() ? 79 : 97);
        result = result * 59 + (this.isNeverCleanupArtifacts() ? 79 : 97);
        result = result * 59 + (this.isCleanWorkingDirectory() ? 79 : 97);
        CRApproval $approval = this.getApproval();
        result = result * 59 + ($approval == null ? 43 : ((Object)$approval).hashCode());
        Collection<CREnvironmentVariable> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Collection<CRJob> $jobs = this.getJobs();
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        return result;
    }
}

