/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;

public class CRTimer
extends CRBase {
    @SerializedName(value="spec")
    @Expose
    private String spec;
    @SerializedName(value="only_on_changes")
    @Expose
    private boolean onlyOnChanges;

    public CRTimer() {
    }

    public CRTimer(String timerSpec, boolean onlyOnChanges) {
        this.spec = timerSpec;
        this.onlyOnChanges = onlyOnChanges;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "spec", this.spec);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; Timer", myLocation);
    }

    public String getSpec() {
        return this.spec;
    }

    public boolean isOnlyOnChanges() {
        return this.onlyOnChanges;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public void setOnlyOnChanges(boolean onlyOnChanges) {
        this.onlyOnChanges = onlyOnChanges;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRTimer)) {
            return false;
        }
        CRTimer other = (CRTimer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$spec = this.getSpec();
        String other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        return this.isOnlyOnChanges() == other.isOnlyOnChanges();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRTimer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        result = result * 59 + (this.isOnlyOnChanges() ? 79 : 97);
        return result;
    }
}

