/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ErrorCollection {
    @SerializedName(value="errors")
    @Expose
    private Map<String, List<String>> errors = new HashMap<String, List<String>>();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isEmpty()) {
            builder.append("No errors");
        } else {
            builder.append(this.getErrorCount());
            builder.append(" errors in partial configuration");
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public int getErrorCount() {
        int count = 0;
        for (List<String> entry : this.errors.values()) {
            count += entry.size();
        }
        return count;
    }

    public String yamlFormat() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, List<String>>> it = this.errors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            sb.append(entry.getKey()).append(':');
            for (String message : entry.getValue()) {
                sb.append('\n').append("  ").append('-').append(' ').append(message);
            }
            if (!it.hasNext()) continue;
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public String getErrorsAsText() {
        StringBuilder errorsBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.errors.entrySet()) {
            errorsBuilder.append('\n');
            errorsBuilder.append(entry.getKey()).append(';');
            for (int i = 1; i <= entry.getValue().size(); ++i) {
                errorsBuilder.append('\n').append(i).append(". ").append(entry.getValue().get(i - 1));
            }
            errorsBuilder.append("\n");
        }
        return errorsBuilder.toString();
    }

    public List<String> getOrCreateErrorList(String location) {
        if (!this.errors.containsKey(location)) {
            this.errors.put(location, new ArrayList());
        }
        return this.errors.get(location);
    }

    public void checkMissing(String location, String fieldName, Object value) {
        if (value == null) {
            List<String> list = this.getOrCreateErrorList(location);
            list.add(String.format("Missing field '%s'.", fieldName));
        }
    }

    public void addError(String location, String error) {
        List<String> list = this.getOrCreateErrorList(location);
        list.add(error);
    }

    public void addErrors(List<CRError> pluginErrors) {
        for (CRError error : pluginErrors) {
            this.addError(error.getLocation(), error.getMessage());
        }
    }
}

