/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;

public class CRDependencyMaterial
extends CRMaterial {
    public static final String TYPE_NAME = "dependency";
    @SerializedName(value="pipeline")
    @Expose
    private String pipeline;
    @SerializedName(value="stage")
    @Expose
    private String stage;

    public CRDependencyMaterial() {
        this.type = TYPE_NAME;
    }

    public CRDependencyMaterial(String name, String pipelineName, String stageName) {
        super(TYPE_NAME, name);
        this.pipeline = pipelineName;
        this.stage = stageName;
    }

    public CRDependencyMaterial(String pipelineName, String stageName) {
        this.type = TYPE_NAME;
        this.pipeline = pipelineName;
        this.stage = stageName;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "pipeline", this.pipeline);
        errors.checkMissing(location, "stage", this.stage);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String pipe = this.getPipeline() != null ? this.getPipeline() : "unknown pipeline";
        String stage = this.getStage() != null ? this.getStage() : "unknown stage";
        return String.format("%s; Dependency material %s on %s/%s", myLocation, name, pipe, stage);
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getStage() {
        return this.stage;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = pipeline;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRDependencyMaterial)) {
            return false;
        }
        CRDependencyMaterial other = (CRDependencyMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pipeline = this.getPipeline();
        String other$pipeline = other.getPipeline();
        if (this$pipeline == null ? other$pipeline != null : !this$pipeline.equals(other$pipeline)) {
            return false;
        }
        String this$stage = this.getStage();
        String other$stage = other.getStage();
        return !(this$stage == null ? other$stage != null : !this$stage.equals(other$stage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRDependencyMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : $pipeline.hashCode());
        String $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
        return result;
    }
}

