/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.ArrayList;
import java.util.List;

public class CRFilter
extends CRBase {
    @SerializedName(value="ignore")
    @Expose
    private List<String> ignore = new ArrayList<String>();
    @SerializedName(value="whitelist")
    @Expose
    private List<String> whitelist = new ArrayList<String>();

    public CRFilter(List<String> list, boolean whitelist) {
        if (whitelist) {
            this.whitelist = list;
        } else {
            this.ignore = list;
        }
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        if (this.isBlacklist() && this.isWhitelist()) {
            errors.addError(this.getLocation(parentLocation), "Material filter cannot contain both ignores and whitelist");
        }
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; Filter", myLocation);
    }

    public boolean isEmpty() {
        return !(this.whitelist != null && !this.whitelist.isEmpty() || this.ignore != null && !this.ignore.isEmpty());
    }

    public boolean isWhitelist() {
        return this.whitelist != null && this.whitelist.size() > 0;
    }

    public List<String> getList() {
        if (this.isBlacklist()) {
            return this.ignore;
        }
        return this.whitelist;
    }

    private boolean isBlacklist() {
        return this.ignore != null && this.ignore.size() > 0;
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
        this.whitelist = null;
    }

    public void setWhitelist(List<String> whitelist) {
        this.ignore = null;
        this.whitelist = whitelist;
    }

    public void setWhitelistNoCheck(List<String> list) {
        this.whitelist = list;
    }

    public List<String> getIgnore() {
        return this.ignore;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRFilter)) {
            return false;
        }
        CRFilter other = (CRFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$ignore = this.getIgnore();
        List<String> other$ignore = other.getIgnore();
        if (this$ignore == null ? other$ignore != null : !((Object)this$ignore).equals(other$ignore)) {
            return false;
        }
        List<String> this$whitelist = this.getWhitelist();
        List<String> other$whitelist = other.getWhitelist();
        return !(this$whitelist == null ? other$whitelist != null : !((Object)this$whitelist).equals(other$whitelist));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $ignore = this.getIgnore();
        result = result * 59 + ($ignore == null ? 43 : ((Object)$ignore).hashCode());
        List<String> $whitelist = this.getWhitelist();
        result = result * 59 + ($whitelist == null ? 43 : ((Object)$whitelist).hashCode());
        return result;
    }
}

