/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;

public class CRPackageMaterial
extends CRMaterial {
    public static final String TYPE_NAME = "package";
    @SerializedName(value="package_id")
    @Expose
    private String packageId;

    public CRPackageMaterial() {
        this(null, null);
    }

    public CRPackageMaterial(String material, String packageId) {
        super(TYPE_NAME, material);
        this.packageId = packageId;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "package_id", this.packageId);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String url = this.getPackageId() != null ? this.getPackageId() : "unknown";
        return String.format("%s; Package material %s ID: %s", myLocation, name, url);
    }

    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRPackageMaterial)) {
            return false;
        }
        CRPackageMaterial other = (CRPackageMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$packageId = this.getPackageId();
        String other$packageId = other.getPackageId();
        return !(this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRPackageMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : $packageId.hashCode());
        return result;
    }
}

