/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRConfigurationProperty;
import com.thoughtworks.go.plugin.configrepo.contract.CRPluginConfiguration;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRFilter;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.SourceCodeMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CRPluggableScmMaterial
extends CRMaterial
implements SourceCodeMaterial {
    public static final String TYPE_NAME = "plugin";
    @SerializedName(value="scm_id")
    @Expose
    private String scmId;
    @SerializedName(value="destination")
    @Expose
    protected String destination;
    @SerializedName(value="filter")
    @Expose
    private CRFilter filter;
    @SerializedName(value="plugin_configuration")
    @Expose
    private CRPluginConfiguration pluginConfiguration;
    @SerializedName(value="configuration")
    @Expose
    private Collection<CRConfigurationProperty> configuration = new ArrayList<CRConfigurationProperty>();

    public CRPluggableScmMaterial() {
        this(null, null, null, null);
    }

    public CRPluggableScmMaterial(String name, String scmId, String directory, List<String> filter) {
        super(TYPE_NAME, name);
        this.scmId = scmId;
        this.destination = directory;
        this.filter = new CRFilter(filter, false);
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    public List<String> getFilterList() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getList();
    }

    public void setFilterIgnore(List<String> filter) {
        this.filter.setIgnore(filter);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        if (this.getScmId() == null && this.pluginConfiguration == null) {
            errors.addError(location, "Either the scm_id or the plugin_configuration must be set");
        }
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String url = this.getScmId() != null ? this.getScmId() : "unknown";
        return String.format("%s; Pluggable SCM material %s ID: %s", myLocation, name, url);
    }

    public String getScmId() {
        return this.scmId;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    public CRFilter getFilter() {
        return this.filter;
    }

    public CRPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public Collection<CRConfigurationProperty> getConfiguration() {
        return this.configuration;
    }

    public void setScmId(String scmId) {
        this.scmId = scmId;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setFilter(CRFilter filter) {
        this.filter = filter;
    }

    public void setPluginConfiguration(CRPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public void setConfiguration(Collection<CRConfigurationProperty> configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRPluggableScmMaterial)) {
            return false;
        }
        CRPluggableScmMaterial other = (CRPluggableScmMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scmId = this.getScmId();
        String other$scmId = other.getScmId();
        if (this$scmId == null ? other$scmId != null : !this$scmId.equals(other$scmId)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        CRFilter this$filter = this.getFilter();
        CRFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        CRPluginConfiguration this$pluginConfiguration = this.getPluginConfiguration();
        CRPluginConfiguration other$pluginConfiguration = other.getPluginConfiguration();
        if (this$pluginConfiguration == null ? other$pluginConfiguration != null : !((Object)this$pluginConfiguration).equals(other$pluginConfiguration)) {
            return false;
        }
        Collection<CRConfigurationProperty> this$configuration = this.getConfiguration();
        Collection<CRConfigurationProperty> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRPluggableScmMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scmId = this.getScmId();
        result = result * 59 + ($scmId == null ? 43 : $scmId.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        CRFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        CRPluginConfiguration $pluginConfiguration = this.getPluginConfiguration();
        result = result * 59 + ($pluginConfiguration == null ? 43 : ((Object)$pluginConfiguration).hashCode());
        Collection<CRConfigurationProperty> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

