/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.tasks;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRBuildFramework;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRNantTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRRunIf;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;

public class CRBuildTask
extends CRTask {
    @SerializedName(value="build_file")
    @Expose
    private String buildFile;
    @SerializedName(value="target")
    @Expose
    private String target;
    @SerializedName(value="working_directory")
    @Expose
    private String workingDirectory;

    public static CRBuildTask rake() {
        return new CRBuildTask(CRBuildFramework.rake);
    }

    public static CRBuildTask rake(String rakeFile) {
        return new CRBuildTask(CRBuildFramework.rake, null, null, rakeFile, null, null);
    }

    public static CRBuildTask rake(String rakeFile, String target) {
        return new CRBuildTask(CRBuildFramework.rake, null, null, rakeFile, target, null);
    }

    public static CRBuildTask rake(String rakeFile, String target, String workingDirectory) {
        return new CRBuildTask(CRBuildFramework.rake, null, null, rakeFile, target, workingDirectory);
    }

    public static CRBuildTask ant() {
        return new CRBuildTask(CRBuildFramework.ant, null, null, null, null, null);
    }

    public static CRBuildTask ant(String antFile) {
        return new CRBuildTask(CRBuildFramework.ant, null, null, antFile, null, null);
    }

    public static CRBuildTask ant(String antFile, String target) {
        return new CRBuildTask(CRBuildFramework.ant, null, null, antFile, target, null);
    }

    public static CRBuildTask ant(String antFile, String target, String workingDirectory) {
        return new CRBuildTask(CRBuildFramework.ant, null, null, antFile, target, workingDirectory);
    }

    public static CRNantTask nant() {
        return new CRNantTask(null, null, null, null, null, null);
    }

    public static CRNantTask nant(String nantPath) {
        return new CRNantTask(null, null, null, null, null, nantPath);
    }

    public static CRNantTask nant(String nantFile, String target) {
        return new CRNantTask(null, null, nantFile, target, null, null);
    }

    public static CRNantTask nant(String nantFile, String target, String workingDirectory) {
        return new CRNantTask(null, null, nantFile, target, workingDirectory, null);
    }

    public static CRNantTask nant(String nantFile, String target, String workingDirectory, String nantPath) {
        return new CRNantTask(null, null, nantFile, target, workingDirectory, nantPath);
    }

    public static CRBuildTask rake(CRRunIf runIf, CRTask onCancel, String buildFile, String target, String workingDirectory) {
        return new CRBuildTask(CRBuildFramework.rake, runIf, onCancel, buildFile, target, workingDirectory);
    }

    public static CRBuildTask ant(CRRunIf runIf, CRTask onCancel, String buildFile, String target, String workingDirectory) {
        return new CRBuildTask(CRBuildFramework.ant, runIf, onCancel, buildFile, target, workingDirectory);
    }

    public CRBuildTask(CRBuildFramework type) {
        this(type, null, null, null, null, null);
    }

    public CRBuildTask(CRBuildFramework type, CRRunIf runIf, CRTask onCancel, String buildFile, String target, String workingDirectory) {
        super(type != null ? type.toString() : null, runIf, onCancel);
        this.buildFile = buildFile;
        this.target = target;
        this.workingDirectory = workingDirectory;
    }

    public CRBuildFramework getType() {
        if (this.type == null) {
            return null;
        }
        return CRBuildFramework.valueOf(this.type);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "type", this.type);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String type = this.getType() == null ? "unknown" : this.getType().toString();
        return String.format("%s; %s build task", myLocation, type);
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getTarget() {
        return this.target;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRBuildTask)) {
            return false;
        }
        CRBuildTask other = (CRBuildTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$buildFile = this.getBuildFile();
        String other$buildFile = other.getBuildFile();
        if (this$buildFile == null ? other$buildFile != null : !this$buildFile.equals(other$buildFile)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$workingDirectory = this.getWorkingDirectory();
        String other$workingDirectory = other.getWorkingDirectory();
        return !(this$workingDirectory == null ? other$workingDirectory != null : !this$workingDirectory.equals(other$workingDirectory));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRBuildTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $buildFile = this.getBuildFile();
        result = result * 59 + ($buildFile == null ? 43 : $buildFile.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : $workingDirectory.hashCode());
        return result;
    }
}

