/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.tasks;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRAbstractFetchTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRRunIf;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;

public class CRFetchArtifactTask
extends CRAbstractFetchTask {
    public static final String ARTIFACT_ORIGIN = "gocd";
    @SerializedName(value="source")
    @Expose
    private String source;
    @SerializedName(value="is_source_a_file")
    @Expose
    private boolean isSourceAFile;
    @SerializedName(value="destination")
    @Expose
    private String destination;

    public CRFetchArtifactTask() {
        this(null, null, null, null, null, null, null, true);
    }

    public CRFetchArtifactTask(CRRunIf runIf, CRTask onCancel, String pipelineName, String stage, String job, String source, String destination, boolean sourceIsDir) {
        super(stage, job, CRAbstractFetchTask.ArtifactOrigin.gocd, runIf, onCancel);
        this.pipeline = pipelineName;
        this.source = source;
        this.isSourceAFile = !sourceIsDir;
        this.destination = destination;
    }

    public boolean sourceIsDirectory() {
        return !this.isSourceAFile;
    }

    public void setSourceIsDirectory(boolean srcIsDirectory) {
        this.isSourceAFile = !srcIsDirectory;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "source", this.source);
        errors.checkMissing(location, "stage", this.stage);
        errors.checkMissing(location, "job", this.job);
    }

    public String getSource() {
        return this.source;
    }

    public boolean isSourceAFile() {
        return this.isSourceAFile;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourceAFile(boolean isSourceAFile) {
        this.isSourceAFile = isSourceAFile;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRFetchArtifactTask)) {
            return false;
        }
        CRFetchArtifactTask other = (CRFetchArtifactTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        if (this.isSourceAFile() != other.isSourceAFile()) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRFetchArtifactTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        result = result * 59 + (this.isSourceAFile() ? 79 : 97);
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        return result;
    }
}

