/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.tasks;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRConfigurationProperty;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRAbstractFetchTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRRunIf;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CRFetchPluggableArtifactTask
extends CRAbstractFetchTask {
    public static final String ARTIFACT_ORIGIN = "external";
    @SerializedName(value="artifact_id")
    @Expose
    private String artifactId;
    @SerializedName(value="configuration")
    @Expose
    private Collection<CRConfigurationProperty> configuration;

    public CRFetchPluggableArtifactTask() {
        super(null, null, CRAbstractFetchTask.ArtifactOrigin.external, null, null);
    }

    public CRFetchPluggableArtifactTask(CRRunIf runIf, CRTask onCancel, String pipelineName, String stage, String job, String artifactId, List<CRConfigurationProperty> crConfigurationProperties) {
        super(stage, job, CRAbstractFetchTask.ArtifactOrigin.external, runIf, onCancel);
        this.artifactId = artifactId;
        this.pipeline = pipelineName;
        this.configuration = crConfigurationProperties;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "artifact_id", this.artifactId);
        errors.checkMissing(location, "stage", this.stage);
        errors.checkMissing(location, "job", this.job);
        if (this.configuration != null) {
            for (CRConfigurationProperty p : this.configuration) {
                p.getErrors(errors, location);
            }
        }
        this.validateKeyUniqueness(errors, location);
    }

    void validateKeyUniqueness(ErrorCollection errors, String location) {
        if (this.configuration != null) {
            ArrayList<String> keys = new ArrayList<String>();
            for (CRConfigurationProperty property : this.configuration) {
                String key = property.getKey();
                if (keys.contains(key)) {
                    errors.addError(location, String.format("Duplicate Configuration property %s", property));
                    continue;
                }
                keys.add(key);
            }
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public Collection<CRConfigurationProperty> getConfiguration() {
        return this.configuration;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setConfiguration(Collection<CRConfigurationProperty> configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRFetchPluggableArtifactTask)) {
            return false;
        }
        CRFetchPluggableArtifactTask other = (CRFetchPluggableArtifactTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        Collection<CRConfigurationProperty> this$configuration = this.getConfiguration();
        Collection<CRConfigurationProperty> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRFetchPluggableArtifactTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        Collection<CRConfigurationProperty> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

