/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.codec;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.go.plugin.configrepo.codec.TypeAdapter;
import com.thoughtworks.go.plugin.configrepo.contract.CRArtifact;
import com.thoughtworks.go.plugin.configrepo.contract.CRBuiltInArtifact;
import com.thoughtworks.go.plugin.configrepo.contract.CRPluggableArtifact;
import java.lang.reflect.Type;

public class ArtifactTypeAdapter
extends TypeAdapter
implements JsonDeserializer<CRArtifact>,
JsonSerializer<CRArtifact> {
    private static final String TYPE = "type";

    public CRArtifact deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        return (CRArtifact)this.determineJsonElementForDistinguishingImplementers(json, context, TYPE, "artifact_origin");
    }

    @Override
    protected Class<?> classForName(String typeName, String origin) {
        if (typeName.equals("external")) {
            return CRPluggableArtifact.class;
        }
        if (typeName.equals("build") || typeName.equals("test")) {
            return CRBuiltInArtifact.class;
        }
        throw new JsonParseException(String.format("Invalid or unknown task type '%s'", typeName));
    }

    public JsonElement serialize(CRArtifact crArtifact, Type type, JsonSerializationContext context) {
        return context.serialize((Object)crArtifact).getAsJsonObject();
    }
}

