/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRArtifact;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.CREnvironmentVariable;
import com.thoughtworks.go.plugin.configrepo.contract.CRTab;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CRJob
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="environment_variables")
    @Expose
    private Collection<CREnvironmentVariable> environmentVariables = new ArrayList<CREnvironmentVariable>();
    @SerializedName(value="tabs")
    @Expose
    private Collection<CRTab> tabs = new ArrayList<CRTab>();
    @SerializedName(value="resources")
    @Expose
    private Collection<String> resources = new ArrayList<String>();
    @SerializedName(value="artifacts")
    @Expose
    private Collection<CRArtifact> artifacts = new ArrayList<CRArtifact>();
    @SerializedName(value="elastic_profile_id")
    @Expose
    private String elasticProfileId;
    @SerializedName(value="run_instance_count")
    @Expose
    private String runInstanceCount;
    @SerializedName(value="timeout")
    @Expose
    private int timeout = 0;
    @SerializedName(value="tasks")
    @Expose
    private List<CRTask> tasks = new ArrayList<CRTask>();

    public CRJob() {
    }

    public CRJob(String name) {
        this.name = name;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "name", this.name);
        this.validateEnvironmentVariableUniqueness(errors, location);
        this.validateTabs(errors, location);
        this.validateArtifacts(errors, location);
        this.validateTasks(errors, location);
        this.validateElasticProfile(errors, location);
    }

    private void validateElasticProfile(ErrorCollection errors, String location) {
        if (this.elasticProfileId != null && this.resources != null && this.resources.size() > 0) {
            errors.addError(location, "elastic_profile_id cannot be specified together with resources");
        }
    }

    private void validateTasks(ErrorCollection errors, String location) {
        errors.checkMissing(location, "tasks", this.tasks);
        if (this.tasks != null) {
            for (CRTask task : this.tasks) {
                task.getErrors(errors, location);
            }
        }
    }

    private void validateArtifacts(ErrorCollection errors, String location) {
        if (this.artifacts == null) {
            return;
        }
        for (CRArtifact artifact : this.artifacts) {
            artifact.getErrors(errors, location);
        }
    }

    private void validateTabs(ErrorCollection errors, String location) {
        if (this.tabs == null) {
            return;
        }
        for (CRTab tab : this.tabs) {
            tab.getErrors(errors, location);
        }
    }

    private void validateEnvironmentVariableUniqueness(ErrorCollection errors, String location) {
        HashSet<String> keys = new HashSet<String>();
        for (CREnvironmentVariable var : this.environmentVariables) {
            String error = var.validateNameUniqueness(keys);
            if (error == null) continue;
            errors.addError(location, error);
        }
    }

    public void addTask(CRTask task) {
        this.tasks.add(task);
    }

    public void addEnvironmentVariable(String key, String value) {
        CREnvironmentVariable variable = new CREnvironmentVariable(key);
        variable.setValue(value);
        this.environmentVariables.add(variable);
    }

    public void addEnvironmentVariable(CREnvironmentVariable variable) {
        this.environmentVariables.add(variable);
    }

    public boolean hasEnvironmentVariable(String key) {
        for (CREnvironmentVariable var : this.environmentVariables) {
            if (!var.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    public void addArtifact(CRArtifact artifact) {
        this.artifacts.add(artifact);
    }

    public boolean isRunOnAllAgents() {
        return this.runInstanceCount != null && this.runInstanceCount.equalsIgnoreCase("all");
    }

    public void setRunOnAllAgents(boolean runOnAllAgents) {
        this.runInstanceCount = runOnAllAgents ? "all" : null;
    }

    public Integer getRunInstanceCount() {
        if (this.runInstanceCount == null) {
            return null;
        }
        return Integer.parseInt(this.runInstanceCount);
    }

    public void setRunInstanceCount(int runInstanceCount) {
        this.runInstanceCount = Integer.toString(runInstanceCount);
    }

    public void addResource(String resource) {
        this.resources.add(resource);
    }

    public void addTab(CRTab tab) {
        this.tabs.add(tab);
    }

    public String validateNameUniqueness(HashSet<String> names) {
        if (names.contains(this.getName())) {
            return String.format("Job %s is defined more than once", this.getName());
        }
        names.add(this.getName());
        return null;
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String stage = this.getName() == null ? "unknown name" : this.getName();
        return String.format("%s; Job (%s)", myLocation, stage);
    }

    public String getName() {
        return this.name;
    }

    public Collection<CREnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Collection<CRTab> getTabs() {
        return this.tabs;
    }

    public Collection<String> getResources() {
        return this.resources;
    }

    public Collection<CRArtifact> getArtifacts() {
        return this.artifacts;
    }

    public String getElasticProfileId() {
        return this.elasticProfileId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List<CRTask> getTasks() {
        return this.tasks;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnvironmentVariables(Collection<CREnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setTabs(Collection<CRTab> tabs) {
        this.tabs = tabs;
    }

    public void setResources(Collection<String> resources) {
        this.resources = resources;
    }

    public void setArtifacts(Collection<CRArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public void setElasticProfileId(String elasticProfileId) {
        this.elasticProfileId = elasticProfileId;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTasks(List<CRTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRJob)) {
            return false;
        }
        CRJob other = (CRJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Collection<CREnvironmentVariable> this$environmentVariables = this.getEnvironmentVariables();
        Collection<CREnvironmentVariable> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Collection<CRTab> this$tabs = this.getTabs();
        Collection<CRTab> other$tabs = other.getTabs();
        if (this$tabs == null ? other$tabs != null : !((Object)this$tabs).equals(other$tabs)) {
            return false;
        }
        Collection<String> this$resources = this.getResources();
        Collection<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Collection<CRArtifact> this$artifacts = this.getArtifacts();
        Collection<CRArtifact> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        String this$elasticProfileId = this.getElasticProfileId();
        String other$elasticProfileId = other.getElasticProfileId();
        if (this$elasticProfileId == null ? other$elasticProfileId != null : !this$elasticProfileId.equals(other$elasticProfileId)) {
            return false;
        }
        Integer this$runInstanceCount = this.getRunInstanceCount();
        Integer other$runInstanceCount = other.getRunInstanceCount();
        if (this$runInstanceCount == null ? other$runInstanceCount != null : !((Object)this$runInstanceCount).equals(other$runInstanceCount)) {
            return false;
        }
        List<CRTask> this$tasks = this.getTasks();
        List<CRTask> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRJob;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTimeout();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Collection<CREnvironmentVariable> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Collection<CRTab> $tabs = this.getTabs();
        result = result * 59 + ($tabs == null ? 43 : ((Object)$tabs).hashCode());
        Collection<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Collection<CRArtifact> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        String $elasticProfileId = this.getElasticProfileId();
        result = result * 59 + ($elasticProfileId == null ? 43 : $elasticProfileId.hashCode());
        Integer $runInstanceCount = this.getRunInstanceCount();
        result = result * 59 + ($runInstanceCount == null ? 43 : ((Object)$runInstanceCount).hashCode());
        List<CRTask> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }
}

