/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;

public class CRTrackingTool
extends CRBase {
    @SerializedName(value="link")
    @Expose
    private String link;
    @SerializedName(value="regex")
    @Expose
    private String regex;

    public CRTrackingTool() {
    }

    public CRTrackingTool(String link, String regex) {
        this.link = link;
        this.regex = regex;
    }

    private void validateLink(ErrorCollection errors, String location) {
        if (this.link != null && !this.link.contains("${ID}")) {
            errors.addError(location, "Link must be a URL containing '${ID}'. Go will replace the string '${ID}' with the first matched group from the regex at run-time.");
        }
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "link", this.link);
        errors.checkMissing(location, "regex", this.regex);
        this.validateLink(errors, location);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; Tracking tool", myLocation);
    }

    public String getLink() {
        return this.link;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRTrackingTool)) {
            return false;
        }
        CRTrackingTool other = (CRTrackingTool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        return !(this$regex == null ? other$regex != null : !this$regex.equals(other$regex));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRTrackingTool;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        return result;
    }
}

