/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRScmMaterial;
import java.util.List;

public class CRHgMaterial
extends CRScmMaterial {
    public static final String TYPE_NAME = "hg";
    @Expose
    @SerializedName(value="url")
    private String url;
    @Expose
    @SerializedName(value="branch")
    private String branch;

    public CRHgMaterial() {
        this(null, null, true, false, null, null, null, null);
    }

    public CRHgMaterial(String name, String folder, boolean autoUpdate, boolean isFilterInverted, String username, List<String> filter, String url, String branch) {
        super(TYPE_NAME, name, folder, autoUpdate, isFilterInverted, username, filter);
        this.url = url;
        this.branch = branch;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        super.getErrors(errors, location);
        this.getCommonErrors(errors, location);
        errors.checkMissing(location, "url", this.url);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String url = this.getUrl() != null ? this.getUrl() : "unknown";
        return String.format("%s; Hg material %s URL: %s", myLocation, name, url);
    }

    public String getBranch() {
        return this.branch;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRHgMaterial)) {
            return false;
        }
        CRHgMaterial other = (CRHgMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRHgMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }
}

