/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import java.util.HashSet;

public abstract class CRMaterial
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="type")
    @Expose
    protected String type;

    public CRMaterial() {
    }

    public CRMaterial(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public abstract String typeName();

    public String validateNameUniqueness(HashSet<String> keys) {
        if (this.getName() == null) {
            return "Material has no name when there many pipeline materials";
        }
        if (keys.contains(this.getName())) {
            return String.format("Material named %s is defined more than once", this.getName());
        }
        keys.add(this.getName());
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRMaterial)) {
            return false;
        }
        CRMaterial other = (CRMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

