/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRScmMaterial;
import java.util.List;

public class CRP4Material
extends CRScmMaterial {
    public static final String TYPE_NAME = "p4";
    @SerializedName(value="port")
    @Expose
    private String port;
    @SerializedName(value="use_tickets")
    @Expose
    private boolean useTickets;
    @SerializedName(value="view")
    @Expose
    private String view;

    public CRP4Material(String materialName, String folder, boolean autoUpdate, boolean isFilterInverted, String username, List<String> filters, String serverAndPort, String view, boolean useTickets) {
        super(TYPE_NAME, materialName, folder, autoUpdate, isFilterInverted, username, filters);
        this.port = serverAndPort;
        this.useTickets = useTickets;
        this.view = view;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        super.getErrors(errors, location);
        this.getCommonErrors(errors, location);
        errors.checkMissing(location, "port", this.port);
        errors.checkMissing(location, "view", this.view);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String port = this.getPort() != null ? this.getPort() : "unknown";
        return String.format("%s; Perforce material %s Port: %s", myLocation, name, port);
    }

    public String getPort() {
        return this.port;
    }

    public boolean isUseTickets() {
        return this.useTickets;
    }

    public String getView() {
        return this.view;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUseTickets(boolean useTickets) {
        this.useTickets = useTickets;
    }

    public void setView(String view) {
        this.view = view;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRP4Material)) {
            return false;
        }
        CRP4Material other = (CRP4Material)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isUseTickets() != other.isUseTickets()) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        return !(this$view == null ? other$view != null : !this$view.equals(other$view));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRP4Material;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isUseTickets() ? 79 : 97);
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        return result;
    }
}

