/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRScmMaterial;
import java.util.List;

public class CRSvnMaterial
extends CRScmMaterial {
    public static final String TYPE_NAME = "svn";
    @SerializedName(value="url")
    @Expose
    private String url;
    @SerializedName(value="check_externals")
    @Expose
    private boolean checkExternals;

    public CRSvnMaterial() {
        this.type = TYPE_NAME;
    }

    public CRSvnMaterial(String materialName, String folder, boolean autoUpdate, boolean isFilterInverted, String username, List<String> filters, String url, boolean checkExternals) {
        super(TYPE_NAME, materialName, folder, autoUpdate, isFilterInverted, username, filters);
        this.url = url;
        this.checkExternals = checkExternals;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        super.getErrors(errors, location);
        this.getCommonErrors(errors, location);
        errors.checkMissing(location, "url", this.url);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String url = this.getUrl() != null ? this.getUrl() : "unknown";
        return String.format("%s; Svn material %s URL: %s", myLocation, name, url);
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isCheckExternals() {
        return this.checkExternals;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCheckExternals(boolean checkExternals) {
        this.checkExternals = checkExternals;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRSvnMaterial)) {
            return false;
        }
        CRSvnMaterial other = (CRSvnMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCheckExternals() != other.isCheckExternals()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRSvnMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCheckExternals() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }
}

