/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRScmMaterial;
import java.util.List;

public class CRTfsMaterial
extends CRScmMaterial {
    public static final String TYPE_NAME = "tfs";
    @SerializedName(value="url")
    @Expose
    private String url;
    @SerializedName(value="domain")
    @Expose
    private String domain;
    @SerializedName(value="project")
    @Expose
    private String project;

    public CRTfsMaterial(String materialName, String folder, boolean autoUpdate, boolean isFilterInverted, String username, List<String> filters, String url, String projectPath, String domain) {
        super(TYPE_NAME, materialName, folder, autoUpdate, isFilterInverted, username, filters);
        this.url = url;
        this.project = projectPath;
        this.domain = domain;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        super.getErrors(errors, parentLocation);
        this.getCommonErrors(errors, location);
        errors.checkMissing(location, "url", this.url);
        errors.checkMissing(location, "username", this.username);
        errors.checkMissing(location, "project", this.project);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String url = this.getUrl() != null ? this.getUrl() : "unknown";
        return String.format("%s; Tfs material %s URL: %s", myLocation, name, url);
    }

    public String getUrl() {
        return this.url;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getProject() {
        return this.project;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRTfsMaterial)) {
            return false;
        }
        CRTfsMaterial other = (CRTfsMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        return !(this$project == null ? other$project != null : !this$project.equals(other$project));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRTfsMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        return result;
    }
}

