/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.tasks;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRFetchArtifactTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRFetchPluggableArtifactTask;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRRunIf;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;
import java.util.Arrays;

public abstract class CRAbstractFetchTask
extends CRTask {
    public static final String TYPE_NAME = "fetch";
    @SerializedName(value="pipeline")
    @Expose
    protected String pipeline;
    @SerializedName(value="stage")
    @Expose
    protected String stage;
    @SerializedName(value="job")
    @Expose
    protected String job;
    @SerializedName(value="artifact_origin")
    @Expose
    protected ArtifactOrigin artifactOrigin;

    protected CRAbstractFetchTask(String stage, String job, ArtifactOrigin artifactOrigin, CRRunIf runIf, CRTask onCancel) {
        super(TYPE_NAME, runIf, onCancel);
        this.stage = stage;
        this.job = job;
        this.artifactOrigin = artifactOrigin;
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String pipe = this.getPipeline() != null ? this.getPipeline() : "unknown pipeline";
        String stage = this.getStage() != null ? this.getStage() : "unknown stage";
        String job = this.getJob() != null ? this.getJob() : "unknown job";
        return String.format("%s; fetch artifacts task from %s %s %s", myLocation, pipe, stage, job);
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getStage() {
        return this.stage;
    }

    public String getJob() {
        return this.job;
    }

    public ArtifactOrigin getArtifactOrigin() {
        return this.artifactOrigin;
    }

    public void setPipeline(String pipeline) {
        this.pipeline = pipeline;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public void setArtifactOrigin(ArtifactOrigin artifactOrigin) {
        this.artifactOrigin = artifactOrigin;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRAbstractFetchTask)) {
            return false;
        }
        CRAbstractFetchTask other = (CRAbstractFetchTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pipeline = this.getPipeline();
        String other$pipeline = other.getPipeline();
        if (this$pipeline == null ? other$pipeline != null : !this$pipeline.equals(other$pipeline)) {
            return false;
        }
        String this$stage = this.getStage();
        String other$stage = other.getStage();
        if (this$stage == null ? other$stage != null : !this$stage.equals(other$stage)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        ArtifactOrigin this$artifactOrigin = this.getArtifactOrigin();
        ArtifactOrigin other$artifactOrigin = other.getArtifactOrigin();
        return !(this$artifactOrigin == null ? other$artifactOrigin != null : !((Object)((Object)this$artifactOrigin)).equals((Object)other$artifactOrigin));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRAbstractFetchTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : $pipeline.hashCode());
        String $stage = this.getStage();
        result = result * 59 + ($stage == null ? 43 : $stage.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        ArtifactOrigin $artifactOrigin = this.getArtifactOrigin();
        result = result * 59 + ($artifactOrigin == null ? 43 : ((Object)((Object)$artifactOrigin)).hashCode());
        return result;
    }

    public static enum ArtifactOrigin {
        gocd{

            @Override
            public Class<? extends CRAbstractFetchTask> getArtifactTaskClass() {
                return CRFetchArtifactTask.class;
            }
        }
        ,
        external{

            @Override
            public Class<? extends CRAbstractFetchTask> getArtifactTaskClass() {
                return CRFetchPluggableArtifactTask.class;
            }
        };


        public abstract Class<? extends CRAbstractFetchTask> getArtifactTaskClass();

        public static ArtifactOrigin getArtifactOrigin(String origin) {
            return Arrays.stream(ArtifactOrigin.values()).filter(item -> item.toString().equals(origin)).findFirst().orElseThrow(() -> new JsonParseException(String.format("Invalid artifact origin '%s' for fetch task.", origin)));
        }
    }
}

