/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.tasks;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRRunIf;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;
import java.util.ArrayList;
import java.util.List;

public class CRExecTask
extends CRTask {
    public static final String TYPE_NAME = "exec";
    @SerializedName(value="command")
    @Expose
    private String command;
    @SerializedName(value="working_directory")
    @Expose
    private String workingDirectory;
    @SerializedName(value="timeout")
    @Expose
    private long timeout;
    @SerializedName(value="arguments")
    @Expose
    private List<String> arguments = new ArrayList<String>();

    public CRExecTask() {
        this(null, null, null, null, 0L);
    }

    public CRExecTask(CRRunIf runIf, CRTask onCancel, String command, String workingDirectory, long timeout) {
        super(TYPE_NAME, runIf, onCancel);
        this.command = command;
        this.workingDirectory = workingDirectory;
        this.timeout = timeout;
    }

    public void addArgument(String arg) {
        this.arguments.add(arg);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "command", this.command);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String command = this.getCommand() != null ? this.getCommand() : "unknown command";
        return String.format("%s; exec task (%s)", myLocation, command);
    }

    public String getCommand() {
        return this.command;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRExecTask)) {
            return false;
        }
        CRExecTask other = (CRExecTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$workingDirectory = this.getWorkingDirectory();
        String other$workingDirectory = other.getWorkingDirectory();
        if (this$workingDirectory == null ? other$workingDirectory != null : !this$workingDirectory.equals(other$workingDirectory)) {
            return false;
        }
        List<String> this$arguments = this.getArguments();
        List<String> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRExecTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $workingDirectory = this.getWorkingDirectory();
        result = result * 59 + ($workingDirectory == null ? 43 : $workingDirectory.hashCode());
        List<String> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }
}

