/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.tasks;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRConfigurationProperty;
import com.thoughtworks.go.plugin.configrepo.contract.CRPluginConfiguration;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRRunIf;
import com.thoughtworks.go.plugin.configrepo.contract.tasks.CRTask;
import java.util.Collection;
import java.util.HashSet;

public class CRPluggableTask
extends CRTask {
    public static final String TYPE_NAME = "plugin";
    @SerializedName(value="plugin_configuration")
    @Expose
    private CRPluginConfiguration pluginConfiguration;
    @SerializedName(value="configuration")
    @Expose
    private Collection<CRConfigurationProperty> configuration;

    public CRPluggableTask() {
        this(null, null, null, null);
    }

    public CRPluggableTask(CRRunIf runIf, CRTask onCancel, CRPluginConfiguration pluginConfiguration, Collection<CRConfigurationProperty> configuration) {
        super(TYPE_NAME, runIf, onCancel);
        this.pluginConfiguration = pluginConfiguration;
        this.configuration = configuration;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "plugin_configuration", this.pluginConfiguration);
        if (this.pluginConfiguration != null) {
            this.pluginConfiguration.getErrors(errors, location);
        }
        if (this.configuration != null) {
            for (CRConfigurationProperty p : this.configuration) {
                p.getErrors(errors, location);
            }
        }
        this.validateKeyUniqueness(errors, location);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; pluggable task", myLocation);
    }

    private void validateKeyUniqueness(ErrorCollection errors, String location) {
        if (this.configuration == null) {
            return;
        }
        HashSet<String> keys = new HashSet<String>();
        for (CRConfigurationProperty property1 : this.configuration) {
            String key = property1.getKey();
            if (keys.contains(key)) {
                errors.addError(location, String.format("Configuration property %s is defined more than once", property1));
                continue;
            }
            keys.add(key);
        }
    }

    public CRPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public Collection<CRConfigurationProperty> getConfiguration() {
        return this.configuration;
    }

    public void setPluginConfiguration(CRPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public void setConfiguration(Collection<CRConfigurationProperty> configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRPluggableTask)) {
            return false;
        }
        CRPluggableTask other = (CRPluggableTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CRPluginConfiguration this$pluginConfiguration = this.getPluginConfiguration();
        CRPluginConfiguration other$pluginConfiguration = other.getPluginConfiguration();
        if (this$pluginConfiguration == null ? other$pluginConfiguration != null : !((Object)this$pluginConfiguration).equals(other$pluginConfiguration)) {
            return false;
        }
        Collection<CRConfigurationProperty> this$configuration = this.getConfiguration();
        Collection<CRConfigurationProperty> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRPluggableTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CRPluginConfiguration $pluginConfiguration = this.getPluginConfiguration();
        result = result * 59 + ($pluginConfiguration == null ? 43 : ((Object)$pluginConfiguration).hashCode());
        Collection<CRConfigurationProperty> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

