/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.codec;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.go.plugin.configrepo.codec.TypeAdapter;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRConfigMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRDependencyMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRGitMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRHgMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRP4Material;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRPackageMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRPluggableScmMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRSvnMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRTfsMaterial;
import java.lang.reflect.Type;

public class MaterialTypeAdapter
extends TypeAdapter
implements JsonDeserializer<CRMaterial>,
JsonSerializer<CRMaterial> {
    private static final String TYPE = "type";

    public CRMaterial deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        return (CRMaterial)this.determineJsonElementForDistinguishingImplementers(json, context, TYPE, "artifact_origin");
    }

    @Override
    protected Class<?> classForName(String typeName, String origin) {
        if (typeName.equals("dependency")) {
            return CRDependencyMaterial.class;
        }
        if (typeName.equals("package")) {
            return CRPackageMaterial.class;
        }
        if (typeName.equals("plugin")) {
            return CRPluggableScmMaterial.class;
        }
        if (typeName.equals("git")) {
            return CRGitMaterial.class;
        }
        if (typeName.equals("hg")) {
            return CRHgMaterial.class;
        }
        if (typeName.equals("svn")) {
            return CRSvnMaterial.class;
        }
        if (typeName.equals("p4")) {
            return CRP4Material.class;
        }
        if (typeName.equals("tfs")) {
            return CRTfsMaterial.class;
        }
        if (typeName.equals("configrepo")) {
            return CRConfigMaterial.class;
        }
        throw new JsonParseException(String.format("Invalid or unknown material type '%s'", typeName));
    }

    public JsonElement serialize(CRMaterial material, Type type, JsonSerializationContext context) {
        return context.serialize((Object)material);
    }
}

