/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRApprovalCondition;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.ArrayList;
import java.util.Collection;

public class CRApproval
extends CRBase {
    @SerializedName(value="type")
    @Expose
    private CRApprovalCondition type;
    @SerializedName(value="users")
    @Expose
    private Collection<String> users = new ArrayList<String>();
    @SerializedName(value="roles")
    @Expose
    private Collection<String> roles = new ArrayList<String>();
    @SerializedName(value="allow_only_on_success")
    @Expose
    private boolean allowOnlyOnSuccess = false;

    public CRApproval() {
    }

    public CRApproval(CRApprovalCondition type) {
        this.type = type;
    }

    public void addAuthorizedUser(String user) {
        this.users.add(user);
    }

    public void addAuthorizedRole(String role) {
        this.roles.add(role);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "type", (Object)this.type);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; Approval", myLocation);
    }

    public void setApprovalCondition(CRApprovalCondition condition) {
        this.type = condition;
    }

    public CRApprovalCondition getType() {
        return this.type;
    }

    public Collection<String> getUsers() {
        return this.users;
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public boolean isAllowOnlyOnSuccess() {
        return this.allowOnlyOnSuccess;
    }

    public void setType(CRApprovalCondition type) {
        this.type = type;
    }

    public void setUsers(Collection<String> users) {
        this.users = users;
    }

    public void setRoles(Collection<String> roles) {
        this.roles = roles;
    }

    public void setAllowOnlyOnSuccess(boolean allowOnlyOnSuccess) {
        this.allowOnlyOnSuccess = allowOnlyOnSuccess;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRApproval)) {
            return false;
        }
        CRApproval other = (CRApproval)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllowOnlyOnSuccess() != other.isAllowOnlyOnSuccess()) {
            return false;
        }
        CRApprovalCondition this$type = this.getType();
        CRApprovalCondition other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Collection<String> this$users = this.getUsers();
        Collection<String> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        Collection<String> this$roles = this.getRoles();
        Collection<String> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRApproval;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAllowOnlyOnSuccess() ? 79 : 97);
        CRApprovalCondition $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Collection<String> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        Collection<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }
}

