/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import org.apache.commons.lang3.StringUtils;

public class CRConfigurationProperty
extends CRBase {
    @SerializedName(value="key")
    @Expose
    private String key;
    @SerializedName(value="value")
    @Expose
    private String value;
    @SerializedName(value="encrypted_value")
    @Expose
    private String encryptedValue;

    public CRConfigurationProperty() {
    }

    public CRConfigurationProperty(String key, String value, String encryptedValue) {
        this.key = key;
        this.value = value;
        this.encryptedValue = encryptedValue;
    }

    public CRConfigurationProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public CRConfigurationProperty(String key) {
        this.key = key;
    }

    public boolean hasEncryptedValue() {
        return StringUtils.isNotBlank((CharSequence)this.encryptedValue);
    }

    public boolean hasPlainTextValue() {
        return StringUtils.isNotBlank((CharSequence)this.value);
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        errors.checkMissing(location, "key", this.key);
        this.validateValues(errors, location);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String key = this.key == null ? "unknown key" : this.key;
        return String.format("%s; Configuration property (%s)", myLocation, key);
    }

    private void validateValues(ErrorCollection errors, String location) {
        if (this.hasEncryptedValue() && this.hasPlainTextValue()) {
            errors.addError(location, "Configuration property must have 'value' or 'encrypted_value' set. Please only one");
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncryptedValue() {
        return this.encryptedValue;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setEncryptedValue(String encryptedValue) {
        this.encryptedValue = encryptedValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRConfigurationProperty)) {
            return false;
        }
        CRConfigurationProperty other = (CRConfigurationProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$encryptedValue = this.getEncryptedValue();
        String other$encryptedValue = other.getEncryptedValue();
        return !(this$encryptedValue == null ? other$encryptedValue != null : !this$encryptedValue.equals(other$encryptedValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRConfigurationProperty;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $encryptedValue = this.getEncryptedValue();
        result = result * 59 + ($encryptedValue == null ? 43 : $encryptedValue.hashCode());
        return result;
    }
}

