/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.config.validation.NameTypeValidator;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.HashSet;

public class CRParameter
extends CRBase {
    @SerializedName(value="name")
    @Expose
    private String name;
    @SerializedName(value="value")
    @Expose
    private String value;

    public CRParameter() {
    }

    public CRParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String key = this.name == null ? "unknown name" : this.name;
        return String.format("%s; Parameter (%s)", myLocation, key);
    }

    public String validateNameUniqueness(HashSet<String> keys) {
        if (keys.contains(this.getName())) {
            return String.format("Param name '%s' is not unique.", this.getName());
        }
        keys.add(this.getName());
        return null;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        if (new NameTypeValidator().isNameInvalid(this.name)) {
            errors.addError(location, NameTypeValidator.errorMessage((String)"parameter", (Object)this.name));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRParameter)) {
            return false;
        }
        CRParameter other = (CRParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

