/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRArtifact;
import com.thoughtworks.go.plugin.configrepo.contract.CRArtifactType;
import com.thoughtworks.go.plugin.configrepo.contract.CRConfigurationProperty;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.Collection;
import java.util.List;

public class CRPluggableArtifact
extends CRArtifact {
    @SerializedName(value="id")
    @Expose
    private String id;
    @SerializedName(value="store_id")
    @Expose
    private String storeId;
    @SerializedName(value="configuration")
    @Expose
    private Collection<CRConfigurationProperty> configuration;

    public CRPluggableArtifact(String id, String storeId, List<CRConfigurationProperty> configurationProperties) {
        super(CRArtifactType.external);
        this.id = id;
        this.storeId = storeId;
        this.configuration = configurationProperties;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        super.getErrors(errors, parentLocation);
        errors.checkMissing(location, "id", this.id);
        errors.checkMissing(location, "store_id", this.storeId);
        if (this.configuration != null) {
            for (CRConfigurationProperty property : this.configuration) {
                property.getErrors(errors, location);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public Collection<CRConfigurationProperty> getConfiguration() {
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setConfiguration(Collection<CRConfigurationProperty> configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRPluggableArtifact)) {
            return false;
        }
        CRPluggableArtifact other = (CRPluggableArtifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        Collection<CRConfigurationProperty> this$configuration = this.getConfiguration();
        Collection<CRConfigurationProperty> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRPluggableArtifact;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        Collection<CRConfigurationProperty> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

