/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRFilter;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;

public class CRConfigMaterial
extends CRMaterial {
    public static final String TYPE_NAME = "configrepo";
    @SerializedName(value="filter")
    @Expose
    private CRFilter filter;
    @SerializedName(value="destination")
    @Expose
    private String destination;

    public CRConfigMaterial() {
        this(null, null, null);
    }

    public CRConfigMaterial(String name, String destination, CRFilter filter) {
        super(TYPE_NAME, name);
        this.destination = destination;
        this.filter = filter;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        if (this.filter != null) {
            this.filter.getErrors(errors, location);
        }
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        return String.format("%s; Config material %s", myLocation, name);
    }

    public CRFilter getFilter() {
        return this.filter;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setFilter(CRFilter filter) {
        this.filter = filter;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRConfigMaterial)) {
            return false;
        }
        CRConfigMaterial other = (CRConfigMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CRFilter this$filter = this.getFilter();
        CRFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRConfigMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CRFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        return result;
    }
}

