/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.CRBase;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import java.util.ArrayList;
import java.util.List;

public class CRFilter
extends CRBase {
    @SerializedName(value="ignore")
    @Expose
    private List<String> ignore = new ArrayList<String>();
    @SerializedName(value="includes")
    @Expose
    private List<String> includes = new ArrayList<String>();

    public CRFilter(List<String> list, boolean isFilterInverted) {
        if (isFilterInverted) {
            this.includes = list;
        } else {
            this.ignore = list;
        }
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        if (this.isIgnored() && this.isIncluded()) {
            errors.addError(this.getLocation(parentLocation), "Material filter cannot contain both ignores and includes");
        }
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        return String.format("%s; Filter", myLocation);
    }

    public boolean isEmpty() {
        return !(this.includes != null && !this.includes.isEmpty() || this.ignore != null && !this.ignore.isEmpty());
    }

    public boolean isIncluded() {
        return this.includes != null && this.includes.size() > 0;
    }

    public List<String> getList() {
        if (this.isIgnored()) {
            return this.ignore;
        }
        return this.includes;
    }

    private boolean isIgnored() {
        return this.ignore != null && this.ignore.size() > 0;
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
        this.includes = null;
    }

    public void setIncludesNoCheck(List<String> list) {
        this.includes = list;
    }

    public List<String> getIgnore() {
        return this.ignore;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRFilter)) {
            return false;
        }
        CRFilter other = (CRFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$ignore = this.getIgnore();
        List<String> other$ignore = other.getIgnore();
        if (this$ignore == null ? other$ignore != null : !((Object)this$ignore).equals(other$ignore)) {
            return false;
        }
        List<String> this$includes = this.getIncludes();
        List<String> other$includes = other.getIncludes();
        return !(this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $ignore = this.getIgnore();
        result = result * 59 + ($ignore == null ? 43 : ((Object)$ignore).hashCode());
        List<String> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        return result;
    }
}

