/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRScmMaterial;
import java.util.List;

public class CRGitMaterial
extends CRScmMaterial {
    public static final String TYPE_NAME = "git";
    @SerializedName(value="url")
    @Expose
    private String url;
    @SerializedName(value="branch")
    @Expose
    private String branch;
    @SerializedName(value="shallow_clone")
    @Expose
    private boolean shallowClone;

    public CRGitMaterial() {
        this(null, null, true, false, null, null, null, null, false);
    }

    public CRGitMaterial(String materialName, String folder, boolean autoUpdate, boolean isFilterInverted, String username, List<String> filters, String url, String branch, boolean shallowClone) {
        super(TYPE_NAME, materialName, folder, autoUpdate, isFilterInverted, username, filters);
        this.url = url;
        this.branch = branch;
        this.shallowClone = shallowClone;
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        super.getErrors(errors, location);
        this.getCommonErrors(errors, location);
        errors.checkMissing(location, "url", this.url);
    }

    @Override
    public String getLocation(String parent) {
        String myLocation = this.getLocation() == null ? parent : this.getLocation();
        String name = this.getName() == null ? "" : this.getName();
        String url = this.getUrl() != null ? this.getUrl() : "unknown";
        return String.format("%s; Git material %s URL: %s", myLocation, name, url);
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isShallowClone() {
        return this.shallowClone;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setShallowClone(boolean shallowClone) {
        this.shallowClone = shallowClone;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRGitMaterial)) {
            return false;
        }
        CRGitMaterial other = (CRGitMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isShallowClone() != other.isShallowClone()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRGitMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isShallowClone() ? 79 : 97);
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }
}

