/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.configrepo.contract.material;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.go.plugin.configrepo.contract.ErrorCollection;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRFilter;
import com.thoughtworks.go.plugin.configrepo.contract.material.CRMaterial;
import com.thoughtworks.go.plugin.configrepo.contract.material.SourceCodeMaterial;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class CRScmMaterial
extends CRMaterial
implements SourceCodeMaterial {
    @SerializedName(value="filter")
    @Expose
    protected CRFilter filter;
    @SerializedName(value="destination")
    @Expose
    protected String destination;
    @SerializedName(value="auto_update")
    @Expose
    protected boolean autoUpdate = true;
    @SerializedName(value="username")
    @Expose
    protected String username;
    @SerializedName(value="password")
    @Expose
    protected String password;
    @SerializedName(value="encrypted_password")
    @Expose
    protected String encryptedPassword;

    public CRScmMaterial() {
    }

    public CRScmMaterial(String type, String materialName, String folder, boolean autoUpdate, boolean isFilterInverted, String username, List<String> filter) {
        super(type, materialName);
        this.destination = folder;
        this.filter = new CRFilter(filter, isFilterInverted);
        this.autoUpdate = autoUpdate;
        this.username = username;
    }

    public List<String> getFilterList() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getList();
    }

    public boolean isWhitelist() {
        if (this.filter != null) {
            return this.filter.isIncluded();
        }
        return false;
    }

    @Override
    public void getErrors(ErrorCollection errors, String parentLocation) {
        this.validatePassword(errors, parentLocation);
    }

    protected void getCommonErrors(ErrorCollection errors, String parentLocation) {
        String location = this.getLocation(parentLocation);
        if (this.filter != null) {
            this.filter.getErrors(errors, location);
        }
    }

    public void setIncludesNoCheck(String ... filters) {
        this.filter.setIncludesNoCheck(Arrays.asList(filters));
    }

    public boolean hasEncryptedPassword() {
        return StringUtils.isNotBlank((CharSequence)this.encryptedPassword);
    }

    public boolean hasPlainTextPassword() {
        return StringUtils.isNotBlank((CharSequence)this.password);
    }

    protected void validatePassword(ErrorCollection errors, String location) {
        if (this.hasEncryptedPassword() && this.hasPlainTextPassword()) {
            errors.addError(location, String.format("%s material has both plain-text and encrypted passwords set. Please set only one password.", this.typeName()));
        }
    }

    public CRFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setFilter(CRFilter filter) {
        this.filter = filter;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRScmMaterial)) {
            return false;
        }
        CRScmMaterial other = (CRScmMaterial)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAutoUpdate() != other.isAutoUpdate()) {
            return false;
        }
        CRFilter this$filter = this.getFilter();
        CRFilter other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$encryptedPassword = this.getEncryptedPassword();
        String other$encryptedPassword = other.getEncryptedPassword();
        return !(this$encryptedPassword == null ? other$encryptedPassword != null : !this$encryptedPassword.equals(other$encryptedPassword));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CRScmMaterial;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAutoUpdate() ? 79 : 97);
        CRFilter $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $encryptedPassword = this.getEncryptedPassword();
        result = result * 59 + ($encryptedPassword == null ? 43 : $encryptedPassword.hashCode());
        return result;
    }
}

