/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.api;

import ch.abertschi.sct.api.Configuration;
import ch.abertschi.sct.api.Interceptor;
import ch.abertschi.sct.api.SctException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ServiceCallTrackerFactory {
    private static final String DEFAULT_IMPL = "ch.abertschi.sct.ServiceCallTracker";

    private ServiceCallTrackerFactory() {
    }

    public static Interceptor lookupInterceptor(Configuration config) throws SctException {
        Interceptor interceptor = null;
        String errMsg = "Can not lookup instance of service-call-tracker";
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(DEFAULT_IMPL);
            Constructor<?> constructor = clazz.getConstructor(Configuration.class);
            constructor.setAccessible(true);
            interceptor = (Interceptor)constructor.newInstance(config);
        }
        catch (ClassNotFoundException e) {
            throw new SctException(errMsg, e);
        }
        catch (NoSuchMethodException e) {
            throw new SctException(errMsg, e);
        }
        catch (InvocationTargetException e) {
            throw new SctException(errMsg, e);
        }
        catch (InstantiationException e) {
            throw new SctException(errMsg, e);
        }
        catch (IllegalAccessException e) {
            throw new SctException(errMsg, e);
        }
        return interceptor;
    }
}

