/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.languageserver.worksheet;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.languageserver.worksheet.Evaluator$;
import dotty.tools.languageserver.worksheet.InputStreamConsumer;
import dotty.tools.languageserver.worksheet.InputStreamConsumer$;
import dotty.tools.languageserver.worksheet.ReplProcess$;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.Properties$;

public class Evaluator {
    private CancelChecker cancelChecker;
    private final Process process;
    private final PrintStream processInput;
    private final InputStreamConsumer processOutput;
    private final Timer cancellationTimer;

    public static Option<Evaluator> get(CancelChecker cancelChecker, Contexts.Context context) {
        return Evaluator$.MODULE$.get(cancelChecker, context);
    }

    public Evaluator(String javaExec, String userClasspath, CancelChecker cancelChecker) {
        this.cancelChecker = cancelChecker;
        this.process = new ProcessBuilder(javaExec, "-classpath", Properties$.MODULE$.javaClassPath(), new StringOps(Predef$.MODULE$.augmentString(ReplProcess$.MODULE$.getClass().getName())).stripSuffix("$"), "-classpath", userClasspath, "-color:never").redirectErrorStream(true).start();
        this.processInput = new PrintStream(this.process().getOutputStream());
        this.processOutput = new InputStreamConsumer(this.process().getInputStream());
        this.cancellationTimer = new Timer();
        TimerTask task = new TimerTask(this){
            private final Evaluator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                if (!this.dotty$tools$languageserver$worksheet$Evaluator$_$_$$anon$$$outer().isAlive()) {
                    this.dotty$tools$languageserver$worksheet$Evaluator$_$_$$anon$$$outer().dotty$tools$languageserver$worksheet$Evaluator$$cancellationTimer().cancel();
                } else {
                    try {
                        this.dotty$tools$languageserver$worksheet$Evaluator$_$_$$anon$$$outer().dotty$tools$languageserver$worksheet$Evaluator$$cancelChecker().checkCanceled();
                    }
                    catch (CancellationException cancellationException) {
                        this.dotty$tools$languageserver$worksheet$Evaluator$_$_$$anon$$$outer().exit();
                    }
                }
            }

            private Evaluator $outer() {
                return this.$outer;
            }

            public final Evaluator dotty$tools$languageserver$worksheet$Evaluator$_$_$$anon$$$outer() {
                return this.$outer();
            }
        };
        long checkCancelledDelayMs = 50L;
        this.dotty$tools$languageserver$worksheet$Evaluator$$cancellationTimer().schedule(task, checkCancelledDelayMs, checkCancelledDelayMs);
    }

    public CancelChecker dotty$tools$languageserver$worksheet$Evaluator$$cancelChecker() {
        return this.cancelChecker;
    }

    private void cancelChecker_$eq(CancelChecker x$1) {
        this.cancelChecker = x$1;
    }

    private Process process() {
        return this.process;
    }

    private PrintStream processInput() {
        return this.processInput;
    }

    private InputStreamConsumer processOutput() {
        return this.processOutput;
    }

    public Timer dotty$tools$languageserver$worksheet$Evaluator$$cancellationTimer() {
        return this.cancellationTimer;
    }

    public boolean isAlive() {
        return this.process().isAlive();
    }

    public String eval(String command) {
        String string;
        this.processInput().print(command);
        this.processInput().print(InputStreamConsumer$.MODULE$.delimiter());
        this.processInput().flush();
        try {
            string = this.processOutput().next().trim();
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    public void reset(CancelChecker cancelChecker) {
        this.cancelChecker_$eq(cancelChecker);
        this.eval(":reset");
    }

    public void exit() {
        this.process().destroyForcibly();
        Evaluator$.MODULE$.dotty$tools$languageserver$worksheet$Evaluator$$$previousEvaluator = None$.MODULE$;
        this.dotty$tools$languageserver$worksheet$Evaluator$$cancellationTimer().cancel();
    }
}

