/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.jmeter;

import java.io.File;
import javax.json.JsonObject;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import step.grid.agent.AgentTokenServices;
import step.grid.agent.handler.AbstractMessageHandler;
import step.grid.agent.handler.context.OutputMessageBuilder;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.filemanager.FileManagerClient;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;
import step.plugins.jmeter.SampleListenerImpl;

public class JMeterLocalHandler
extends AbstractMessageHandler {
    String jmeterHome;

    public void init(AgentTokenServices tokenServices) {
        super.init(tokenServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputMessage handle(AgentTokenWrapper token, InputMessage message) throws Exception {
        ApplicationContextBuilder.ApplicationContext context = token.getServices().getApplicationContextBuilder().getCurrentContext();
        if (context.get((Object)"initialized") == null) {
            FileManagerClient.FileVersionId jmeterLibs = this.getFileVersionId("$jmeter.libraries", message.getProperties());
            FileManagerClient.FileVersion jmeterLibFolder = token.getServices().getFileManagerClient().requestFileVersion(jmeterLibs.getFileId(), jmeterLibs.getVersion());
            this.jmeterHome = jmeterLibFolder.getFile().getAbsolutePath();
            this.updateClasspathSystemProperty();
            JMeterUtils.setJMeterHome((String)this.jmeterHome);
            JMeterUtils.loadJMeterProperties((String)(this.jmeterHome + "/bin/jmeter.properties"));
            JMeterUtils.initLogging();
            JMeterUtils.initLocale();
            context.put("initialized", (Object)true);
        }
        OutputMessageBuilder out = new OutputMessageBuilder();
        File testPlanFile = this.retrieveFileVersion("$jmeter.testplan.file", message.getProperties()).getFile();
        StandardJMeterEngine jmeter = new StandardJMeterEngine();
        final HashTree testPlanTree = SaveService.loadTree((File)testPlanFile);
        final Arguments arguments = this.createArguments(message);
        final SampleListenerImpl listener = new SampleListenerImpl(out);
        testPlanTree.traverse(new HashTreeTraverser(){

            public void subtractNode() {
            }

            public void processPath() {
            }

            public void addNode(Object node, HashTree subTree) {
                if (node instanceof TestPlan) {
                    testPlanTree.getTree(node).add((Object)listener);
                    testPlanTree.getTree(node).add((Object)arguments);
                }
            }
        });
        jmeter.configure(testPlanTree);
        try {
            jmeter.run();
        }
        finally {
            listener.collect();
        }
        return out.build();
    }

    private Arguments createArguments(InputMessage message) {
        Arguments arguments = new Arguments();
        JsonObject inputJson = message.getArgument();
        if (inputJson != null) {
            for (String key : inputJson.keySet()) {
                arguments.addArgument(key, inputJson.getString(key));
            }
        }
        return arguments;
    }

    private void updateClasspathSystemProperty() {
        String cp = System.getProperty("java.class.path");
        File extFolder = new File(this.jmeterHome + "/lib/ext");
        if (extFolder.exists() && extFolder.isDirectory()) {
            for (File jar : extFolder.listFiles()) {
                cp = cp + ";" + jar.getAbsolutePath();
            }
        }
        System.setProperty("java.class.path", cp);
    }
}

