/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.jmeter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import step.grid.agent.handler.context.OutputMessageBuilder;

public class SampleListenerImpl
extends AbstractTestElement
implements SampleListener,
Cloneable {
    private static final long serialVersionUID = -4394201534114759490L;
    OutputMessageBuilder outputBuilder;
    List<SampleResult> samples = Collections.synchronizedList(new ArrayList());

    public SampleListenerImpl() {
    }

    public SampleListenerImpl(OutputMessageBuilder outputBuilder) {
        this.outputBuilder = outputBuilder;
    }

    public void sampleOccurred(SampleEvent e) {
        SampleResult result = e.getResult();
        this.samples.add(result);
        this.outputBuilder.addMeasure(result.getSampleLabel(), result.getTime(), this.getDataMapForSample(result));
    }

    private Map<String, Object> getDataMapForSample(SampleResult sample) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (sample instanceof HTTPSampleResult) {
            HTTPSampleResult httpSampleResult = (HTTPSampleResult)sample;
            data.put("url", httpSampleResult.getUrlAsString());
            data.put("httpMethod", httpSampleResult.getHTTPMethod());
            data.put("responseCode", httpSampleResult.getResponseCode());
        }
        return data;
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public OutputMessageBuilder getOut() {
        return this.outputBuilder;
    }

    public void setOut(OutputMessageBuilder out) {
        this.outputBuilder = out;
    }

    public void collect() {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (SampleResult sample : this.samples) {
            JsonObjectBuilder object = Json.createObjectBuilder();
            this.mapSampleAttributesToReturnObject(object, sample);
            array.add((JsonValue)object.build());
        }
        this.outputBuilder.getPayloadBuilder().add("samples", (JsonValue)array.build());
    }

    private void mapSampleAttributesToReturnObject(JsonObjectBuilder object, SampleResult sample) {
        object.add("label", sample.getSampleLabel());
        if (sample instanceof HTTPSampleResult) {
            HTTPSampleResult httpSampleResult = (HTTPSampleResult)sample;
            object.add("url", httpSampleResult.getUrlAsString());
            object.add("method", httpSampleResult.getHTTPMethod());
            object.add("responseCode", httpSampleResult.getResponseCode());
        }
    }

    public Object clone() {
        Object clone = super.clone();
        ((SampleListenerImpl)clone).outputBuilder = this.outputBuilder;
        ((SampleListenerImpl)clone).samples = this.samples;
        return clone;
    }
}

