/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.GlobalContext;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;
import step.core.accessors.collections.Collection;
import step.core.accessors.collections.CollectionRegistry;
import step.core.deployment.ObjectHookControllerPlugin;
import step.core.entities.Entity;
import step.core.imports.GenericDBImporter;
import step.core.imports.Importer;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.plugins.AbstractControllerPlugin;
import step.core.plugins.Plugin;
import step.engine.plugins.ExecutionEnginePlugin;
import step.parameter.Parameter;
import step.parameter.ParameterManager;
import step.plugins.parametermanager.ParameterCollection;
import step.plugins.parametermanager.ParameterManagerPlugin;
import step.plugins.parametermanager.ParameterServices;
import step.plugins.screentemplating.Input;
import step.plugins.screentemplating.InputType;
import step.plugins.screentemplating.ScreenInput;
import step.plugins.screentemplating.ScreenInputAccessor;
import step.plugins.screentemplating.ScreenTemplatePlugin;

@Plugin(dependencies={ObjectHookControllerPlugin.class, ScreenTemplatePlugin.class})
public class ParameterManagerControllerPlugin
extends AbstractControllerPlugin {
    private static final String entityName = "parameters";
    public static Logger logger = LoggerFactory.getLogger(ParameterManagerControllerPlugin.class);
    protected ParameterManager parameterManager;
    private static final String PARAMETER_DIALOG = "parameterDialog";
    private static final String PARAMETER_TABLE = "parameterTable";

    public void executionControllerStart(GlobalContext context) {
        AbstractCRUDAccessor parameterAccessor = new AbstractCRUDAccessor(context.getMongoClientSession(), entityName, Parameter.class);
        context.put("ParameterAccessor", (Object)parameterAccessor);
        ((CollectionRegistry)context.get(CollectionRegistry.class)).register(entityName, (Collection)new ParameterCollection(context.getMongoClientSession().getMongoDatabase()));
        ParameterManager parameterManager = new ParameterManager((CRUDAccessor)parameterAccessor, context.getConfiguration());
        context.put(ParameterManager.class, (Object)parameterManager);
        this.parameterManager = parameterManager;
        context.getEntityManager().register(new Entity(entityName, (CRUDAccessor)parameterAccessor, Parameter.class, (Importer)new GenericDBImporter(context)));
        ((ObjectHookRegistry)context.require(ObjectHookRegistry.class)).add((Object)parameterManager.getObjectHook());
        context.getServiceRegistrationCallback().registerService(ParameterServices.class);
    }

    public void initializeData(GlobalContext context) throws Exception {
        this.createScreenInputDefinitionsIfNecessary(context);
    }

    public ExecutionEnginePlugin getExecutionEnginePlugin() {
        return new ParameterManagerPlugin(this.parameterManager);
    }

    private void createScreenInputDefinitionsIfNecessary(GlobalContext context) {
        ScreenInputAccessor screenInputAccessor = (ScreenInputAccessor)context.get(ScreenInputAccessor.class);
        List parameterTable = screenInputAccessor.getScreenInputsByScreenId(PARAMETER_TABLE);
        Input keyInput = new Input(InputType.TEXT, "key", "Key", "Keys containing 'pwd' or 'password' will be automatically protected", null);
        keyInput.setValueHtmlTemplate("<entity-icon entity=\"stBean\" entity-name=\"'parameter'\"/> <parameter-key parameter=\"stBean\" st-options=\"stOptions\" />");
        if (parameterTable.isEmpty()) {
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(0, PARAMETER_TABLE, keyInput));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(1, PARAMETER_TABLE, new Input(InputType.TEXT, "value", "Value", null, null)));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(2, PARAMETER_TABLE, new Input(InputType.TEXT, "activationExpression.script", "Activation script", null, null)));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(3, PARAMETER_TABLE, new Input(InputType.TEXT, "priority", "\tPriority", null, null)));
        }
        parameterTable.forEach(i -> {
            Input input = i.getInput();
            if (input.getId().equals("key")) {
                i.setInput(keyInput);
                screenInputAccessor.save((AbstractIdentifiableObject)i);
            }
        });
        if (screenInputAccessor.getScreenInputsByScreenId(PARAMETER_DIALOG).isEmpty()) {
            Input input = new Input(InputType.TEXT, "key", "Key", "Keys containing 'pwd' or 'password' will be automatically protected", null);
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(0, PARAMETER_DIALOG, input));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(1, PARAMETER_DIALOG, new Input(InputType.TEXT, "value", "Value", null, null)));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(2, PARAMETER_DIALOG, new Input(InputType.TEXT, "description", "Description", null, null)));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(3, PARAMETER_DIALOG, new Input(InputType.TEXT, "activationExpression.script", "Activation script", null, null)));
            screenInputAccessor.save((AbstractIdentifiableObject)new ScreenInput(4, PARAMETER_DIALOG, new Input(InputType.TEXT, "priority", "\tPriority", null, null)));
        }
    }
}

