/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.parametermanager;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.bson.types.ObjectId;
import step.commons.activation.Expression;
import step.core.GlobalContext;
import step.core.access.AccessManager;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.parameter.Parameter;
import step.parameter.ParameterScope;

@Path(value="/parameters")
public class ParameterServices
extends AbstractServices {
    private AccessManager accessManager;
    private CRUDAccessor<Parameter> parameterAccessor;
    public static final String PROTECTED_VALUE = "******";

    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.getContext();
        this.parameterAccessor = (CRUDAccessor)context.get((Object)"ParameterAccessor");
        this.accessManager = (AccessManager)context.get(AccessManager.class);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter newParameter() {
        Parameter parameter = new Parameter(new Expression(""), "", "", "");
        parameter.setPriority(Integer.valueOf(1));
        if (this.hasGlobalParamRight()) {
            parameter.setScope(ParameterScope.GLOBAL);
        } else {
            parameter.setScope(ParameterScope.FUNCTION);
        }
        return parameter;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter save(Parameter newParameter) {
        this.assertRights(newParameter);
        Parameter oldParameter = newParameter.getId() != null ? (Parameter)this.parameterAccessor.get(newParameter.getId()) : null;
        if (oldParameter == null) {
            newParameter.setProtectedValue(Boolean.valueOf(ParameterServices.isPassword(newParameter)));
        } else {
            if (newParameter.getValue().equals(PROTECTED_VALUE)) {
                newParameter.setValue(oldParameter.getValue());
            }
            if (this.isProtected(oldParameter)) {
                newParameter.setProtectedValue(Boolean.valueOf(true));
            } else {
                newParameter.setProtectedValue(Boolean.valueOf(ParameterServices.isPassword(newParameter)));
            }
        }
        ParameterScope scope = newParameter.getScope();
        if (scope != null && scope.equals((Object)ParameterScope.GLOBAL)) {
            newParameter.setScopeEntity(null);
        }
        String lastModificationUser = this.getSession().getUser().getUsername();
        Date lastModificationDate = new Date();
        newParameter.setLastModificationDate(lastModificationDate);
        newParameter.setLastModificationUser(lastModificationUser);
        return (Parameter)this.parameterAccessor.save((AbstractIdentifiableObject)newParameter);
    }

    protected void assertRights(Parameter newParameter) {
        if (!(newParameter.getScope() != null && newParameter.getScope() != ParameterScope.GLOBAL || this.hasGlobalParamRight())) {
            throw new RuntimeException("The user is missing the right 'param-global-write' to write global parameters.");
        }
    }

    protected boolean hasGlobalParamRight() {
        return this.accessManager.checkRightInContext(this.getSession(), "param-global-write");
    }

    protected boolean isProtected(Parameter oldParameter) {
        return oldParameter.getProtectedValue() != null && oldParameter.getProtectedValue() != false;
    }

    @POST
    @Path(value="/{id}/copy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(right="param-write")
    public Parameter copy(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        parameter.setId(new ObjectId());
        return this.save(parameter);
    }

    @DELETE
    @Path(value="/{id}")
    @Secured(right="param-delete")
    public void delete(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        this.assertRights(parameter);
        this.parameterAccessor.remove(new ObjectId(id));
    }

    public static boolean isPassword(Parameter parameter) {
        return parameter != null && ParameterServices.isPassword(parameter.getKey());
    }

    public static boolean isPassword(String key) {
        return key != null && (key.contains("pwd") || key.contains("password"));
    }

    @GET
    @Path(value="/{id}")
    @Secured(right="param-read")
    public Parameter get(@PathParam(value="id") String id) {
        Parameter parameter = (Parameter)this.parameterAccessor.get(new ObjectId(id));
        return this.maskProtectedValue(parameter);
    }

    protected Parameter maskProtectedValue(Parameter parameter) {
        if (parameter != null && this.isProtected(parameter)) {
            parameter.setValue(PROTECTED_VALUE);
        }
        return parameter;
    }

    protected List<Parameter> maskProtectedValues(Stream<Parameter> stream) {
        return stream.map(p -> this.maskProtectedValue((Parameter)p)).collect(Collectors.toList());
    }

    @POST
    @Path(value="/search")
    @Produces(value={"application/json"})
    @Secured(right="param-read")
    public Parameter get(Map<String, String> attributes) {
        return this.maskProtectedValue((Parameter)this.parameterAccessor.findByAttributes(attributes));
    }

    @POST
    @Path(value="/find")
    @Produces(value={"application/json"})
    @Secured(right="param-read")
    public List<Parameter> findMany(Map<String, String> attributes) {
        return this.maskProtectedValues(StreamSupport.stream(this.parameterAccessor.findManyByAttributes(attributes), false));
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Secured(right="param-read")
    public List<Parameter> getAll(@QueryParam(value="skip") Integer skip, @QueryParam(value="limit") Integer limit) {
        List range = skip != null && limit != null ? this.parameterAccessor.getRange(skip.intValue(), limit.intValue()) : this.getAll(0, 1000);
        return this.maskProtectedValues(range.stream());
    }
}

