/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.threadmanager;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.common.managedoperations.Operation;
import step.common.managedoperations.OperationManager;
import step.core.artefacts.reports.ReportNode;
import step.core.execution.ExecutionContext;

public class ThreadManager {
    private static final Logger logger = LoggerFactory.getLogger(ThreadManager.class);
    private List<Pattern> matchingPatterns = new ArrayList<Pattern>();
    private static final String SET_KEY = "ThreadManagerPlugin_SetKey";
    private Map<String, List<Long>> reportNodeIdToThreadId = new ConcurrentHashMap<String, List<Long>>();

    public void registerPattern(Pattern pattern) {
        this.matchingPatterns.add(pattern);
    }

    public void registerClass(Class<?> clazz) {
        this.matchingPatterns.add(Pattern.compile(clazz.getName().replace(".", "\\.") + ".*"));
    }

    private boolean matches(StackTraceElement[] stacktrace) {
        for (Pattern p : this.matchingPatterns) {
            Matcher m = p.matcher("");
            for (StackTraceElement el : stacktrace) {
                m.reset(el.getClassName() + "." + el.getMethodName());
                if (!m.matches()) continue;
                return true;
            }
        }
        return false;
    }

    private HashSet<Thread> getRegister(ExecutionContext context) {
        return (HashSet)context.get((Object)SET_KEY);
    }

    public void associateThread(ExecutionContext context, Thread thread, long parentThreadId) {
        logger.debug("associate Thread: " + thread.getId() + ", and parent thread id: " + parentThreadId);
        this.reportNodeIdToThreadId.entrySet().stream().filter(e -> ((List)e.getValue()).contains(parentThreadId)).forEach(e -> ((List)e.getValue()).add(thread.getId()));
        this.associateThread(context, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateThread(ExecutionContext context, Thread thread) {
        HashSet<Thread> associatedThreads = this.getRegister(context);
        Object object = context;
        synchronized (object) {
            if (associatedThreads == null) {
                associatedThreads = new HashSet();
                context.put(SET_KEY, associatedThreads);
            }
        }
        object = associatedThreads;
        synchronized (object) {
            associatedThreads.add(thread);
        }
    }

    public void beforeReportNodeExecution(ExecutionContext context, ReportNode node) {
        String reportNodeId = node.getId().toString();
        long threadId = Thread.currentThread().getId();
        List threads = this.reportNodeIdToThreadId.computeIfAbsent(reportNodeId, k -> new CopyOnWriteArrayList());
        threads.add(threadId);
    }

    public void afterReportNodeExecution(ExecutionContext context, ReportNode node) {
        String reportNodeId = node.getId().toString();
        this.reportNodeIdToThreadId.remove(reportNodeId);
    }

    public List<Operation> getCurrentOperationsByReportNodeId(String reportNodeId) {
        OperationManager operationManager = OperationManager.getInstance();
        List<Long> threadIds = this.reportNodeIdToThreadId.get(reportNodeId);
        if (threadIds != null) {
            return threadIds.stream().map(threadId -> operationManager.getOperation(threadId)).filter(o -> o != null).collect(Collectors.toList());
        }
        return new ArrayList<Operation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unassociateThread(ExecutionContext context, Thread thread) {
        HashSet<Thread> associatedThreads;
        HashSet<Thread> hashSet = associatedThreads = this.getRegister(context);
        synchronized (hashSet) {
            associatedThreads.remove(thread);
        }
        long threadId = thread.getId();
        this.reportNodeIdToThreadId.entrySet().forEach(e -> ((List)e.getValue()).remove(threadId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeExecutionEnd(ExecutionContext context) {
        HashSet<Thread> associatedThreads;
        HashSet<Thread> hashSet = associatedThreads = this.getRegister(context);
        synchronized (hashSet) {
            for (Thread thread : associatedThreads) {
                if (!this.matches(thread.getStackTrace())) continue;
                thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Operation> getCurrentOperations(ExecutionContext context) {
        HashSet<Thread> associatedThreads = this.getRegister(context);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        if (associatedThreads != null) {
            HashSet<Thread> hashSet = associatedThreads;
            synchronized (hashSet) {
                for (Thread thread : associatedThreads) {
                    Operation op = OperationManager.getInstance().getOperation(Long.valueOf(thread.getId()));
                    if (op == null) continue;
                    operations.add(op);
                }
            }
        }
        return operations;
    }
}

