/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.threadmanager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import step.artefacts.reports.TestCaseReportNode;
import step.common.managedoperations.Operation;
import step.common.managedoperations.OperationDetails;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.ExecutionContext;
import step.core.plans.Plan;
import step.plugins.threadmanager.ThreadManager;

@Path(value="/threadmanager")
public class ThreadManagerServices
extends AbstractServices {
    private ThreadManager threadManager;

    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.threadManager = (ThreadManager)this.getContext().get(ThreadManager.class);
    }

    @GET
    @Secured(right="admin")
    @Produces(value={"application/json"})
    @Path(value="/operations/list")
    public List<OperationDetails> getCurrentOperationsList() {
        ArrayList<OperationDetails> operationListDetails = new ArrayList<OperationDetails>();
        for (ExecutionContext executionContext : this.getScheduler().getCurrentExecutions()) {
            String executionId = executionContext.getExecutionId();
            Plan plan = executionContext.getPlan();
            if (plan == null) continue;
            String planId = plan.getId().toString();
            String planName = (String)plan.getAttributes().get("name");
            String executionType = executionContext.getExecutionType();
            if ("TestSet".equals(executionType)) {
                Iterator iterator = this.getContext().getReportAccessor().getReportNodesByExecutionIDAndClass(executionId, TestCaseReportNode.class.getName());
                iterator.forEachRemaining(e -> {
                    String testcase = e.getName();
                    this.threadManager.getCurrentOperationsByReportNodeId(e.getId().toString()).forEach(op -> operationListDetails.add(new OperationDetails(executionId, planId, planName, testcase, op)));
                });
                continue;
            }
            this.threadManager.getCurrentOperations(executionContext).forEach(op -> operationListDetails.add(new OperationDetails(executionId, planId, planName, "", op)));
        }
        return operationListDetails;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/operations")
    @Secured(right="execution-read")
    public List<Operation> getCurrentOperations(@QueryParam(value="eid") String executionID) {
        ExecutionContext executionContext = this.getExecutionRunnable(executionID);
        if (executionContext != null) {
            return this.threadManager.getCurrentOperations(executionContext);
        }
        return new ArrayList<Operation>();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/operations/{reportnodeid}")
    @Secured(right="execution-read")
    public List<Operation> getOperationsByReportNodeId(@PathParam(value="reportnodeid") String reportNodeId) {
        return this.threadManager.getCurrentOperationsByReportNodeId(reportNodeId);
    }
}

