/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.views;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.artefacts.reports.ReportNode;
import step.core.scanner.CachedAnnotationScanner;
import step.plugins.views.AbstractView;
import step.plugins.views.View;
import step.plugins.views.ViewModel;
import step.plugins.views.ViewModelAccessor;

public class ViewManager {
    private static final Logger logger = LoggerFactory.getLogger(ViewManager.class);
    private final ConcurrentHashMap<String, AbstractView<ViewModel>> register = new ConcurrentHashMap();
    private ViewModelAccessor accessor;

    public ViewManager(ViewModelAccessor accessor) {
        this.accessor = accessor;
        this.loadViews();
    }

    public Collection<AbstractView<ViewModel>> getViews() {
        return this.register.values();
    }

    private void loadViews() {
        Set viewClasses = CachedAnnotationScanner.getClassesWithAnnotation(View.class);
        for (Class viewClass : viewClasses) {
            try {
                AbstractView view = (AbstractView)viewClass.newInstance();
                this.registerView(view.getViewId(), view);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("Error while loading view " + viewClass.toString(), (Throwable)e);
            }
        }
    }

    public void registerView(String viewId, AbstractView<ViewModel> view) {
        this.register.put(viewId, view);
    }

    public void createViewModelsForExecution(String executionId) {
        for (AbstractView<ViewModel> view : this.getViews()) {
            try {
                ViewModel model = view.init();
                model.setExecutionId(executionId);
                model.setViewId(view.getViewId());
                view.addModel(executionId, model);
            }
            catch (Exception e) {
                logger.error("Error while initializing view " + view.getViewId(), (Throwable)e);
            }
        }
    }

    public void closeViewModelsForExecution(String executionId) {
        for (AbstractView<ViewModel> view : this.getViews()) {
            try {
                ViewModel model = view.removeModel(executionId);
                this.accessor.save(model);
            }
            catch (Exception e) {
                logger.error("Error while saving view " + view.getViewId(), (Throwable)e);
            }
        }
    }

    public void afterReportNodeSkeletonCreation(ReportNode node) {
        this.invokeViewHooks(node, (model, view) -> view.afterReportNodeSkeletonCreation(model, node));
    }

    public void afterReportNodeExecution(ReportNode node) {
        this.invokeViewHooks(node, (model, view) -> view.afterReportNodeExecution(model, node));
    }

    public void rollbackReportNode(ReportNode node) {
        this.invokeViewHooks(node, (model, view) -> view.rollbackReportNode(model, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeViewHooks(ReportNode node, BiConsumer<ViewModel, AbstractView<ViewModel>> consumer) {
        for (AbstractView<ViewModel> view : this.getViews()) {
            ViewModel model;
            ViewModel viewModel = model = view.getModel(node.getExecutionID());
            synchronized (viewModel) {
                try {
                    consumer.accept(model, view);
                }
                catch (Exception e) {
                    logger.error("Error while invoking view " + view.getViewId() + " for node " + node.toString(), (Throwable)e);
                }
            }
        }
    }

    public ViewModel queryView(String viewId, String executionId) {
        AbstractView<ViewModel> view = this.register.get(viewId);
        if (view != null) {
            ViewModel model = view.getModel(executionId);
            if (model == null) {
                model = this.accessor.get(viewId, executionId, ViewModel.class);
                if (model != null) {
                    return model;
                }
                return view.init();
            }
            return model;
        }
        throw new RuntimeException("Invalid view id: " + viewId);
    }
}

